/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.catalog.hive.util.HiveReflectionUtils;
import org.apache.flink.table.module.hive.udf.generic.HiveGenericUDFGrouping;
import org.apache.flink.table.operations.ExplainOperation;
import org.apache.flink.table.operations.NopOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.delegation.ParserImpl;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.delegation.hive.HiveParserCalcitePlanner;
import org.apache.flink.table.planner.delegation.hive.HiveParserDMLHelper;
import org.apache.flink.table.planner.delegation.hive.SqlFunctionConverter;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseException;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserContext;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQueryState;
import org.apache.flink.table.planner.delegation.hive.parse.HiveParserCreateViewInfo;
import org.apache.flink.table.planner.delegation.hive.parse.HiveParserDDLSemanticAnalyzer;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.apache.flink.table.planner.plan.FlinkCalciteCatalogReader;
import org.apache.flink.util.FileUtils;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParser
extends ParserImpl {
    private static final Logger LOG = LoggerFactory.getLogger(HiveParser.class);
    private static final Method setCurrentTSMethod = HiveReflectionUtils.tryGetMethod(SessionState.class, "setupQueryCurrentTimestamp", new Class[0]);
    private static final Method getCurrentTSMethod = HiveReflectionUtils.tryGetMethod(SessionState.class, "getQueryCurrentTimestamp", new Class[0]);
    private static final Set<Integer> DDL_NODES = new HashSet<Integer>(Arrays.asList(658, 688, 710, 743, 951, 748, 749, 750, 734, 736, 735, 821, 657, 656, 915, 921, 913, 931, 932, 924, 925, 917, 920, 918, 919, 916, 923, 933, 649, 914, 922, 712, 745, 665, 816, 1004, 815, 1003, 715, 747, 769, 894, 926, 771, 895, 928, 929, 929, 655, 654, 994, 930, 701, 714, 746, 716, 711, 744, 884, 717, 653, 718));
    private final PlannerContext plannerContext;
    private final FlinkCalciteCatalogReader catalogReader;
    private final FrameworkConfig frameworkConfig;
    private final SqlFunctionConverter funcConverter;
    private final HiveParserDMLHelper dmlHelper;

    HiveParser(CatalogManager catalogManager, Supplier<FlinkPlannerImpl> validatorSupplier, Supplier<CalciteParser> calciteParserSupplier, PlannerContext plannerContext) {
        super(catalogManager, validatorSupplier, calciteParserSupplier, plannerContext.getSqlExprToRexConverterFactory());
        this.plannerContext = plannerContext;
        this.catalogReader = plannerContext.createCatalogReader(false, catalogManager.getCurrentCatalog(), catalogManager.getCurrentDatabase());
        this.frameworkConfig = plannerContext.createFrameworkConfig();
        this.funcConverter = new SqlFunctionConverter(plannerContext.getCluster(), this.frameworkConfig.getOperatorTable(), this.catalogReader.nameMatcher());
        this.dmlHelper = new HiveParserDMLHelper(plannerContext, this.funcConverter, catalogManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Operation> parse(String statement) {
        CatalogManager catalogManager = this.getCatalogManager();
        Catalog currentCatalog = catalogManager.getCatalog(catalogManager.getCurrentCatalog()).orElse(null);
        if (!(currentCatalog instanceof HiveCatalog)) {
            LOG.warn("Current catalog is not HiveCatalog. Falling back to Flink's planner.");
            return super.parse(statement);
        }
        HiveConf hiveConf = new HiveConf(((HiveCatalog)currentCatalog).getHiveConf());
        hiveConf.setVar(HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
        hiveConf.set("hive.allow.udf.load.on.demand", "false");
        hiveConf.setVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, "mr");
        HiveShim hiveShim = HiveShimLoader.loadHiveShim(((HiveCatalog)currentCatalog).getHiveVersion());
        try {
            this.startSessionState(hiveConf, catalogManager);
            hiveShim.registerTemporaryFunction("grouping", HiveGenericUDFGrouping.class);
            List<Operation> list = this.processCmd(statement, hiveConf, hiveShim, (HiveCatalog)currentCatalog);
            return list;
        }
        finally {
            this.clearSessionState();
        }
    }

    private List<Operation> processCmd(String cmd, HiveConf hiveConf, HiveShim hiveShim, HiveCatalog hiveCatalog) {
        try {
            HiveParserContext context = new HiveParserContext(hiveConf);
            HiveParserASTNode node = HiveASTParseUtils.parse(cmd, context);
            if (DDL_NODES.contains(node.getType())) {
                HiveParserQueryState queryState = new HiveParserQueryState(hiveConf);
                HiveParserDDLSemanticAnalyzer ddlAnalyzer = new HiveParserDDLSemanticAnalyzer(queryState, hiveCatalog, this.getCatalogManager(), this, hiveShim, context, this.dmlHelper);
                Operation operation = ddlAnalyzer.convertToOperation(node);
                return Collections.singletonList(operation);
            }
            boolean explain = node.getType() == 754;
            HiveParserASTNode input = explain ? (HiveParserASTNode)node.getChild(0) : node;
            Operation operation = this.analyzeSql(context, hiveConf, hiveShim, input);
            if (explain && !(operation instanceof NopOperation)) {
                operation = new ExplainOperation(operation);
            }
            return Collections.singletonList(operation);
        }
        catch (HiveASTParseException e) {
            try {
                return super.parse(cmd);
            }
            catch (SqlParserException parserException) {
                throw new SqlParserException("SQL parse failed", (Throwable)e);
            }
        }
        catch (SemanticException e) {
            throw new ValidationException("HiveParser failed to parse " + cmd, (Throwable)e);
        }
    }

    public HiveParserCalcitePlanner createCalcitePlanner(HiveParserContext context, HiveParserQueryState queryState, HiveShim hiveShim) throws SemanticException {
        HiveParserCalcitePlanner calciteAnalyzer = new HiveParserCalcitePlanner(queryState, this.plannerContext, this.catalogReader, this.frameworkConfig, this.getCatalogManager(), hiveShim);
        calciteAnalyzer.initCtx(context);
        calciteAnalyzer.init(false);
        return calciteAnalyzer;
    }

    public void analyzeCreateView(HiveParserCreateViewInfo createViewInfo, HiveParserContext context, HiveParserQueryState queryState, HiveShim hiveShim) throws SemanticException {
        HiveParserCalcitePlanner calciteAnalyzer = this.createCalcitePlanner(context, queryState, hiveShim);
        calciteAnalyzer.setCreatViewInfo(createViewInfo);
        calciteAnalyzer.genLogicalPlan(createViewInfo.getQuery());
    }

    private Operation analyzeSql(HiveParserContext context, HiveConf hiveConf, HiveShim hiveShim, HiveParserASTNode node) throws SemanticException {
        HiveParserCalcitePlanner analyzer = this.createCalcitePlanner(context, new HiveParserQueryState(hiveConf), hiveShim);
        RelNode relNode = analyzer.genLogicalPlan(node);
        if (relNode == null) {
            return new NopOperation();
        }
        if (!analyzer.getQB().getIsQuery()) {
            return this.dmlHelper.createInsertOperation(analyzer, relNode);
        }
        return new PlannerQueryOperation(relNode);
    }

    private void startSessionState(HiveConf hiveConf, CatalogManager catalogManager) {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        try {
            HiveParserSessionState sessionState = new HiveParserSessionState(hiveConf, contextCL);
            sessionState.initTxnMgr(hiveConf);
            sessionState.setCurrentDatabase(catalogManager.getCurrentDatabase());
            HiveParser.setCurrentTimestamp(sessionState);
            SessionState.setCurrentSessionState(sessionState);
        }
        catch (LockException e) {
            throw new FlinkHiveException("Failed to init SessionState", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextCL);
        }
    }

    private static void setCurrentTimestamp(HiveParserSessionState sessionState) {
        if (setCurrentTSMethod != null) {
            try {
                setCurrentTSMethod.invoke((Object)sessionState, new Object[0]);
                Object currentTs = getCurrentTSMethod.invoke((Object)sessionState, new Object[0]);
                if (currentTs instanceof Instant) {
                    sessionState.hiveParserCurrentTS = Timestamp.from((Instant)currentTs);
                }
                sessionState.hiveParserCurrentTS = (Timestamp)currentTs;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new FlinkHiveException("Failed to set current timestamp for session", e);
            }
        } else {
            sessionState.hiveParserCurrentTS = new Timestamp(System.currentTimeMillis());
        }
    }

    private void clearSessionState() {
        SessionState sessionState = SessionState.get();
        if (sessionState != null) {
            try {
                sessionState.close();
            }
            catch (Exception e) {
                LOG.warn("Error closing SessionState", (Throwable)e);
            }
        }
    }

    public static class HiveParserSessionState
    extends SessionState {
        private static final Class registryClz = HiveReflectionUtils.tryGetClass("org.apache.hadoop.hive.ql.exec.Registry");
        private static final Method getRegistry;
        private static final Method clearRegistry;
        private static final Method closeRegistryLoaders;
        private Timestamp hiveParserCurrentTS;
        private final ClassLoader originContextLoader;
        private final ClassLoader hiveLoader;

        public HiveParserSessionState(HiveConf conf, ClassLoader contextLoader) {
            super(conf);
            this.originContextLoader = contextLoader;
            this.hiveLoader = this.getConf().getClassLoader();
            this.getConf().setClassLoader(contextLoader);
        }

        @Override
        public void close() throws IOException {
            this.clearSessionRegistry();
            if (this.getTxnMgr() != null) {
                this.getTxnMgr().closeTxnManager();
            }
            JavaUtils.closeClassLoadersTo(this.hiveLoader, this.originContextLoader);
            File resourceDir = new File(this.getConf().getVar(HiveConf.ConfVars.DOWNLOADED_RESOURCES_DIR));
            LOG.debug("Removing resource dir " + resourceDir);
            FileUtils.deleteDirectoryQuietly((File)resourceDir);
            Hive.closeCurrent();
            HiveParserSessionState.detachSession();
        }

        public Timestamp getHiveParserCurrentTS() {
            return this.hiveParserCurrentTS;
        }

        private void clearSessionRegistry() {
            if (getRegistry != null) {
                try {
                    Object registry = getRegistry.invoke((Object)this, new Object[0]);
                    if (registry != null) {
                        clearRegistry.invoke(registry, new Object[0]);
                        closeRegistryLoaders.invoke(registry, new Object[0]);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOG.warn("Failed to clear session registry", (Throwable)e);
                }
            }
        }

        static {
            if (registryClz != null) {
                getRegistry = HiveReflectionUtils.tryGetMethod(SessionState.class, "getRegistry", new Class[0]);
                clearRegistry = HiveReflectionUtils.tryGetMethod(registryClz, "clear", new Class[0]);
                closeRegistryLoaders = HiveReflectionUtils.tryGetMethod(registryClz, "closeCUDFLoaders", new Class[0]);
            } else {
                getRegistry = null;
                clearRegistry = null;
                closeRegistryLoaders = null;
            }
        }
    }
}

