/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.mapred.JobConf;

public abstract class BaseWork
extends AbstractOperatorDesc {
    List<HashTableDummyOperator> dummyOps;
    int tag;
    private final List<String> sortColNames = new ArrayList<String>();
    private MapredLocalWork mrLocalWork;
    private boolean gatheringStats;
    private String name;
    protected Map<String, Integer> vectorColumnNameMap;
    protected Map<Integer, String> vectorColumnTypeMap;
    protected Map<Integer, String> vectorScratchColumnTypeMap;

    public BaseWork() {
    }

    public BaseWork(String name) {
        this.setName(name);
    }

    public void setGatheringStats(boolean gatherStats) {
        this.gatheringStats = gatherStats;
    }

    public boolean isGatheringStats() {
        return this.gatheringStats;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<HashTableDummyOperator> getDummyOps() {
        return this.dummyOps;
    }

    public void setDummyOps(List<HashTableDummyOperator> dummyOps) {
        this.dummyOps = dummyOps;
    }

    public void addDummyOp(HashTableDummyOperator dummyOp) {
        if (this.dummyOps == null) {
            this.dummyOps = new LinkedList<HashTableDummyOperator>();
        }
        this.dummyOps.add(dummyOp);
    }

    public abstract void replaceRoots(Map<Operator<?>, Operator<?>> var1);

    public abstract Set<Operator<?>> getAllRootOperators();

    public Set<Operator<?>> getAllOperators() {
        LinkedHashSet returnSet = new LinkedHashSet();
        Set<Operator<?>> opSet = this.getAllRootOperators();
        Stack opStack = new Stack();
        opStack.addAll(opSet);
        while (!opStack.empty()) {
            Operator op = (Operator)opStack.pop();
            returnSet.add(op);
            if (op.getChildOperators() == null) continue;
            opStack.addAll(op.getChildOperators());
        }
        return returnSet;
    }

    public Set<Operator<?>> getAllLeafOperators() {
        LinkedHashSet returnSet = new LinkedHashSet();
        Set<Operator<?>> opSet = this.getAllRootOperators();
        Stack opStack = new Stack();
        opStack.addAll(opSet);
        while (!opStack.empty()) {
            Operator op = (Operator)opStack.pop();
            if (op.getNumChild() == 0) {
                returnSet.add(op);
            }
            if (op.getChildOperators() == null) continue;
            opStack.addAll(op.getChildOperators());
        }
        return returnSet;
    }

    public Map<String, Integer> getVectorColumnNameMap() {
        return this.vectorColumnNameMap;
    }

    public void setVectorColumnNameMap(Map<String, Integer> vectorColumnNameMap) {
        this.vectorColumnNameMap = vectorColumnNameMap;
    }

    public Map<Integer, String> getVectorColumnTypeMap() {
        return this.vectorColumnTypeMap;
    }

    public void setVectorColumnTypeMap(Map<Integer, String> vectorColumnTypeMap) {
        this.vectorColumnTypeMap = vectorColumnTypeMap;
    }

    public Map<Integer, String> getVectorScratchColumnTypeMap() {
        return this.vectorScratchColumnTypeMap;
    }

    public void setVectorScratchColumnTypeMap(Map<Integer, String> vectorScratchColumnTypeMap) {
        this.vectorScratchColumnTypeMap = vectorScratchColumnTypeMap;
    }

    @Explain(displayName="Local Work", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public MapredLocalWork getMapRedLocalWork() {
        return this.mrLocalWork;
    }

    public void setMapRedLocalWork(MapredLocalWork mapLocalWork) {
        this.mrLocalWork = mapLocalWork;
    }

    public abstract void configureJobConf(JobConf var1);

    public void setTag(int tag) {
        this.tag = tag;
    }

    public int getTag() {
        return this.tag;
    }

    public void addSortCols(List<String> sortCols) {
        this.sortColNames.addAll(sortCols);
    }

    public List<String> getSortCols() {
        return this.sortColNames;
    }
}

