/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskResult;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hadoop.hive.ql.session.SessionState;

public class TaskRunner
extends Thread {
    protected Task<? extends Serializable> tsk;
    protected TaskResult result;
    protected SessionState ss;
    private OperationLog operationLog;
    private static AtomicLong taskCounter = new AtomicLong(0L);
    private static ThreadLocal<Long> taskRunnerID = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return taskCounter.incrementAndGet();
        }
    };
    protected Thread runner;

    public TaskRunner(Task<? extends Serializable> tsk, TaskResult result) {
        this.tsk = tsk;
        this.result = result;
        this.ss = SessionState.get();
    }

    public Task<? extends Serializable> getTask() {
        return this.tsk;
    }

    public TaskResult getTaskResult() {
        return this.result;
    }

    public Thread getRunner() {
        return this.runner;
    }

    public boolean isRunning() {
        return this.result.isRunning();
    }

    @Override
    public void run() {
        this.runner = Thread.currentThread();
        try {
            OperationLog.setCurrentOperationLog(this.operationLog);
            SessionState.start(this.ss);
            this.runSequential();
        }
        finally {
            this.runner = null;
        }
    }

    public void runSequential() {
        int exitVal = -101;
        try {
            exitVal = this.tsk.executeTask();
        }
        catch (Throwable t) {
            if (this.tsk.getException() == null) {
                this.tsk.setException(t);
            }
            t.printStackTrace();
        }
        this.result.setExitVal(exitVal, this.tsk.getException());
    }

    public static long getTaskRunnerID() {
        return taskRunnerID.get();
    }

    public void setOperationLog(OperationLog operationLog) {
        this.operationLog = operationLog;
    }
}

