/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.hadoop.bulk.committer;

import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.apache.flink.formats.hadoop.bulk.HadoopFileCommitter;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HadoopRenameFileCommitter
implements HadoopFileCommitter {
    private final Configuration configuration;
    private final Path targetFilePath;
    private final Path tempFilePath;

    public HadoopRenameFileCommitter(Configuration configuration, Path targetFilePath) throws IOException {
        this.configuration = configuration;
        this.targetFilePath = targetFilePath;
        this.tempFilePath = this.generateTempFilePath();
    }

    public HadoopRenameFileCommitter(Configuration configuration, Path targetFilePath, Path inProgressPath) throws IOException {
        this.configuration = configuration;
        this.targetFilePath = targetFilePath;
        this.tempFilePath = inProgressPath;
    }

    @Override
    public Path getTargetFilePath() {
        return this.targetFilePath;
    }

    @Override
    public Path getTempFilePath() {
        return this.tempFilePath;
    }

    @Override
    public void preCommit() {
    }

    @Override
    public void commit() throws IOException {
        this.rename(true);
    }

    @Override
    public void commitAfterRecovery() throws IOException {
        this.rename(false);
    }

    private void rename(boolean assertFileExists) throws IOException {
        FileSystem fileSystem = FileSystem.get((URI)this.targetFilePath.toUri(), (Configuration)this.configuration);
        if (!fileSystem.exists(this.tempFilePath)) {
            if (assertFileExists) {
                throw new IOException(String.format("In progress file(%s) not exists.", this.tempFilePath));
            }
            return;
        }
        try {
            fileSystem.rename(this.tempFilePath, this.targetFilePath);
        }
        catch (IOException e) {
            throw new IOException(String.format("Could not commit file from %s to %s", this.tempFilePath, this.targetFilePath), e);
        }
    }

    private Path generateTempFilePath() throws IOException {
        Path candidate;
        Preconditions.checkArgument((boolean)this.targetFilePath.isAbsolute(), (Object)"Target file must be absolute");
        FileSystem fileSystem = FileSystem.get((URI)this.targetFilePath.toUri(), (Configuration)this.configuration);
        Path parent = this.targetFilePath.getParent();
        String name = this.targetFilePath.getName();
        while (fileSystem.exists(candidate = new Path(parent, "." + name + ".inprogress." + UUID.randomUUID().toString()))) {
        }
        return candidate;
    }
}

