/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.read;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connectors.hive.ConsumeOrder;
import org.apache.flink.connectors.hive.JobConfWrapper;
import org.apache.flink.connectors.hive.util.HivePartitionUtils;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.util.HiveReflectionUtils;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.filesystem.DefaultPartTimeExtractor;
import org.apache.flink.table.filesystem.FileSystemOptions;
import org.apache.flink.table.filesystem.PartitionFetcher;
import org.apache.flink.table.filesystem.PartitionTimeExtractor;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;

public abstract class HivePartitionFetcherContextBase<P>
implements PartitionFetcher.Context<P> {
    private static final long serialVersionUID = 1L;
    protected final ObjectPath tablePath;
    protected final HiveShim hiveShim;
    protected final JobConfWrapper confWrapper;
    protected final List<String> partitionKeys;
    protected final DataType[] fieldTypes;
    protected final String[] fieldNames;
    protected final Configuration configuration;
    protected final String defaultPartitionName;
    protected final ConsumeOrder consumeOrder;
    protected transient IMetaStoreClient metaStoreClient;
    protected transient StorageDescriptor tableSd;
    protected transient Properties tableProps;
    protected transient org.apache.hadoop.fs.Path tableLocation;
    protected transient FileSystem fs;
    private transient PartitionTimeExtractor extractor;
    private transient Table table;

    public HivePartitionFetcherContextBase(ObjectPath tablePath, HiveShim hiveShim, JobConfWrapper confWrapper, List<String> partitionKeys, DataType[] fieldTypes, String[] fieldNames, Configuration configuration, String defaultPartitionName) {
        this.tablePath = tablePath;
        this.hiveShim = hiveShim;
        this.confWrapper = confWrapper;
        this.partitionKeys = partitionKeys;
        this.fieldTypes = fieldTypes;
        this.fieldNames = fieldNames;
        this.configuration = configuration;
        this.defaultPartitionName = defaultPartitionName;
        String consumeOrderStr = (String)configuration.get(FileSystemOptions.STREAMING_SOURCE_PARTITION_ORDER);
        this.consumeOrder = ConsumeOrder.getConsumeOrder(consumeOrderStr);
    }

    public void open() throws Exception {
        this.metaStoreClient = this.hiveShim.getHiveMetastoreClient(new HiveConf((org.apache.hadoop.conf.Configuration)this.confWrapper.conf(), HiveConf.class));
        this.table = this.metaStoreClient.getTable(this.tablePath.getDatabaseName(), this.tablePath.getObjectName());
        this.tableSd = this.table.getSd();
        this.tableProps = HiveReflectionUtils.getTableMetadata(this.hiveShim, this.table);
        String extractorKind = (String)this.configuration.get(FileSystemOptions.PARTITION_TIME_EXTRACTOR_KIND);
        String extractorClass = (String)this.configuration.get(FileSystemOptions.PARTITION_TIME_EXTRACTOR_CLASS);
        String extractorPattern = (String)this.configuration.get(FileSystemOptions.PARTITION_TIME_EXTRACTOR_TIMESTAMP_PATTERN);
        this.extractor = PartitionTimeExtractor.create((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)extractorKind, (String)extractorClass, (String)extractorPattern);
        this.tableLocation = new org.apache.hadoop.fs.Path(this.table.getSd().getLocation());
        this.fs = this.tableLocation.getFileSystem((org.apache.hadoop.conf.Configuration)this.confWrapper.conf());
    }

    public List<PartitionFetcher.Context.ComparablePartitionValue> getComparablePartitionValueList() throws Exception {
        ArrayList<PartitionFetcher.Context.ComparablePartitionValue> partitionValueList = new ArrayList<PartitionFetcher.Context.ComparablePartitionValue>();
        switch (this.consumeOrder) {
            case PARTITION_NAME_ORDER: {
                List<String> partitionNames = this.metaStoreClient.listPartitionNames(this.tablePath.getDatabaseName(), this.tablePath.getObjectName(), (short)Short.MAX_VALUE);
                for (String partitionName : partitionNames) {
                    partitionValueList.add(this.getComparablePartitionByName(partitionName));
                }
                break;
            }
            case CREATE_TIME_ORDER: {
                FileStatus[] statuses;
                for (FileStatus status : statuses = HivePartitionUtils.getFileStatusRecurse(this.tableLocation, this.partitionKeys.size(), this.fs)) {
                    List partValues = PartitionPathUtils.extractPartitionValues((Path)new Path(status.getPath().toString()));
                    Long creatTime = TimestampData.fromTimestamp((Timestamp)new Timestamp(status.getModificationTime())).getMillisecond();
                    partitionValueList.add(this.getComparablePartitionByTime(partValues, creatTime));
                }
                break;
            }
            case PARTITION_TIME_ORDER: {
                List<String> partitionNames = this.metaStoreClient.listPartitionNames(this.tablePath.getDatabaseName(), this.tablePath.getObjectName(), (short)Short.MAX_VALUE);
                for (String partitionName : partitionNames) {
                    List partValues = PartitionPathUtils.extractPartitionValues((Path)new Path(partitionName));
                    Long partitionTime = DefaultPartTimeExtractor.toMills((LocalDateTime)this.extractor.extract(this.partitionKeys, partValues));
                    partitionValueList.add(this.getComparablePartitionByTime(partValues, partitionTime));
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported consumer order: " + (Object)((Object)this.consumeOrder));
            }
        }
        return partitionValueList;
    }

    private PartitionFetcher.Context.ComparablePartitionValue<List<String>, Long> getComparablePartitionByTime(final List<String> partValues, final Long time) {
        return new PartitionFetcher.Context.ComparablePartitionValue<List<String>, Long>(){
            private static final long serialVersionUID = 1L;

            public List<String> getPartitionValue() {
                return partValues;
            }

            public Long getComparator() {
                return time;
            }
        };
    }

    private PartitionFetcher.Context.ComparablePartitionValue<List<String>, String> getComparablePartitionByName(final String partitionName) {
        return new PartitionFetcher.Context.ComparablePartitionValue<List<String>, String>(){
            private static final long serialVersionUID = 1L;

            public List<String> getPartitionValue() {
                return PartitionPathUtils.extractPartitionValues((Path)new Path(partitionName));
            }

            public String getComparator() {
                return partitionName;
            }
        };
    }

    public void close() throws Exception {
        if (this.metaStoreClient != null) {
            this.metaStoreClient.close();
        }
    }
}

