/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.enumerate.FileEnumerator;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.connectors.hive.JobConfWrapper;
import org.apache.flink.connectors.hive.read.HiveSourceSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;

public class HiveSourceFileEnumerator
implements FileEnumerator {
    private final List<HiveTablePartition> partitions;
    private final JobConf jobConf;

    public HiveSourceFileEnumerator(List<HiveTablePartition> partitions, JobConf jobConf) {
        this.partitions = partitions;
        this.jobConf = jobConf;
    }

    public Collection<FileSourceSplit> enumerateSplits(Path[] paths, int minDesiredSplits) throws IOException {
        return new ArrayList<FileSourceSplit>(HiveSourceFileEnumerator.createInputSplits(minDesiredSplits, this.partitions, this.jobConf));
    }

    public static List<HiveSourceSplit> createInputSplits(int minNumSplits, List<HiveTablePartition> partitions, JobConf jobConf) throws IOException {
        ArrayList<HiveSourceSplit> hiveSplits = new ArrayList<HiveSourceSplit>();
        FileSystem fs = null;
        for (HiveTablePartition partition : partitions) {
            InputSplit[] splitArray;
            InputFormat format;
            StorageDescriptor sd = partition.getStorageDescriptor();
            org.apache.hadoop.fs.Path inputPath = new org.apache.hadoop.fs.Path(sd.getLocation());
            if (fs == null) {
                fs = inputPath.getFileSystem((Configuration)jobConf);
            }
            if (!fs.exists(inputPath)) continue;
            try {
                format = (InputFormat)Class.forName(sd.getInputFormat(), true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Exception e) {
                throw new FlinkHiveException("Unable to instantiate the hadoop input format", e);
            }
            ReflectionUtils.setConf((Object)format, (Configuration)jobConf);
            jobConf.set("mapreduce.input.fileinputformat.inputdir", sd.getLocation());
            for (InputSplit inputSplit : splitArray = format.getSplits(jobConf, minNumSplits)) {
                Preconditions.checkState((boolean)(inputSplit instanceof FileSplit), (Object)("Unsupported InputSplit type: " + inputSplit.getClass().getName()));
                hiveSplits.add(new HiveSourceSplit((FileSplit)inputSplit, partition, null));
            }
        }
        return hiveSplits;
    }

    public static int getNumFiles(List<HiveTablePartition> partitions, JobConf jobConf) throws IOException {
        int numFiles = 0;
        FileSystem fs = null;
        for (HiveTablePartition partition : partitions) {
            StorageDescriptor sd = partition.getStorageDescriptor();
            org.apache.hadoop.fs.Path inputPath = new org.apache.hadoop.fs.Path(sd.getLocation());
            if (fs == null) {
                fs = inputPath.getFileSystem((Configuration)jobConf);
            }
            if (!fs.exists(inputPath)) continue;
            numFiles += fs.listStatus(inputPath).length;
        }
        return numFiles;
    }

    public static class Provider
    implements FileEnumerator.Provider {
        private static final long serialVersionUID = 1L;
        private final List<HiveTablePartition> partitions;
        private final JobConfWrapper jobConfWrapper;

        public Provider(List<HiveTablePartition> partitions, JobConfWrapper jobConfWrapper) {
            this.partitions = partitions;
            this.jobConfWrapper = jobConfWrapper;
        }

        public FileEnumerator create() {
            return new HiveSourceFileEnumerator(this.partitions, this.jobConfWrapper.conf());
        }
    }
}

