/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hive.common.util.AnnotationUtils;

public class HiveJoinPushTransitivePredicatesRule
extends RelOptRule {
    private final RelFactories.FilterFactory filterFactory;
    public static final HiveJoinPushTransitivePredicatesRule INSTANCE = new HiveJoinPushTransitivePredicatesRule(Join.class, RelFactories.DEFAULT_FILTER_FACTORY);

    public HiveJoinPushTransitivePredicatesRule(Class<? extends Join> clazz, RelFactories.FilterFactory filterFactory) {
        super(HiveJoinPushTransitivePredicatesRule.operand(clazz, (RelOptRuleOperand)HiveJoinPushTransitivePredicatesRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveJoinPushTransitivePredicatesRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{HiveJoinPushTransitivePredicatesRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveJoinPushTransitivePredicatesRule.any())}));
        this.filterFactory = filterFactory;
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode curr;
        Join join = (Join)call.rel(0);
        RelOptPredicateList preds = RelMetadataQuery.getPulledUpPredicates((RelNode)join);
        RexBuilder rB = join.getCluster().getRexBuilder();
        RelNode lChild = call.rel(1);
        RelNode rChild = call.rel(2);
        ImmutableList<RexNode> leftPreds = this.getValidPreds(preds.leftInferredPredicates, lChild.getRowType().getFieldList());
        ImmutableList<RexNode> rightPreds = this.getValidPreds(preds.rightInferredPredicates, rChild.getRowType().getFieldList());
        if (leftPreds.isEmpty() && rightPreds.isEmpty()) {
            return;
        }
        if (leftPreds.size() > 0) {
            curr = lChild;
            lChild = this.filterFactory.createFilter(lChild, RexUtil.composeConjunction((RexBuilder)rB, leftPreds, (boolean)false));
            call.getPlanner().onCopy(curr, lChild);
        }
        if (rightPreds.size() > 0) {
            curr = rChild;
            rChild = this.filterFactory.createFilter(rChild, RexUtil.composeConjunction((RexBuilder)rB, rightPreds, (boolean)false));
            call.getPlanner().onCopy(curr, rChild);
        }
        Join newRel = join.copy(join.getTraitSet(), join.getCondition(), lChild, rChild, join.getJoinType(), join.isSemiJoinDone());
        call.getPlanner().onCopy((RelNode)join, (RelNode)newRel);
        call.transformTo((RelNode)newRel);
    }

    private ImmutableList<RexNode> getValidPreds(List<RexNode> rexs, List<RelDataTypeField> types) {
        InputRefValidator validator = new InputRefValidator(types);
        ArrayList<RexNode> valids = new ArrayList<RexNode>(rexs.size());
        for (RexNode rex : rexs) {
            try {
                rex.accept((RexVisitor)validator);
                valids.add(rex);
            }
            catch (Util.FoundOne e) {
                Util.swallow((Throwable)e, null);
            }
        }
        return ImmutableList.copyOf(valids);
    }

    private static class InputRefValidator
    extends RexVisitorImpl<Void> {
        private final List<RelDataTypeField> types;

        protected InputRefValidator(List<RelDataTypeField> types) {
            super(true);
            this.types = types;
        }

        public Void visitCall(RexCall call) {
            if (AnnotationUtils.getAnnotation(GenericUDFOPNotNull.class, Description.class).name().equals(call.getOperator().getName()) && call.getOperands().get(0) instanceof RexInputRef && !this.types.get(((RexInputRef)call.getOperands().get(0)).getIndex()).getType().isNullable()) {
                throw new Util.FoundOne((Object)call);
            }
            return (Void)super.visitCall(call);
        }
    }
}

