/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.write;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.serde2.io.ParquetHiveRecord;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.Progressable;
import parquet.hadoop.ParquetOutputFormat;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.hadoop.util.ContextUtil;

public class ParquetRecordWriterWrapper
implements RecordWriter<Void, ParquetHiveRecord>,
FileSinkOperator.RecordWriter {
    public static final Log LOG = LogFactory.getLog(ParquetRecordWriterWrapper.class);
    private final org.apache.hadoop.mapreduce.RecordWriter<Void, ParquetHiveRecord> realWriter;
    private final TaskAttemptContext taskContext;

    public ParquetRecordWriterWrapper(OutputFormat<Void, ParquetHiveRecord> realOutputFormat, JobConf jobConf, String name, Progressable progress, Properties tableProperties) throws IOException {
        try {
            TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)jobConf.get("mapred.task.id"));
            if (taskAttemptID == null) {
                taskAttemptID = new TaskAttemptID();
            }
            this.taskContext = ContextUtil.newTaskAttemptContext((Configuration)jobConf, taskAttemptID);
            LOG.info((Object)"initialize serde with table properties.");
            this.initializeSerProperties((JobContext)this.taskContext, tableProperties);
            LOG.info((Object)("creating real writer to write at " + name));
            this.realWriter = ((ParquetOutputFormat)realOutputFormat).getRecordWriter(this.taskContext, new Path(name));
            LOG.info((Object)("real writer: " + this.realWriter));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void initializeSerProperties(JobContext job, Properties tableProperties) {
        String compressionName;
        String enableDictionaryPage;
        String blockSize = tableProperties.getProperty("parquet.block.size");
        Configuration conf = ContextUtil.getConfiguration(job);
        if (blockSize != null && !blockSize.isEmpty()) {
            LOG.debug((Object)"get override parquet.block.size property via tblproperties");
            conf.setInt("parquet.block.size", Integer.valueOf(blockSize).intValue());
        }
        if ((enableDictionaryPage = tableProperties.getProperty("parquet.enable.dictionary")) != null && !enableDictionaryPage.isEmpty()) {
            LOG.debug((Object)"get override parquet.enable.dictionary property via tblproperties");
            conf.setBoolean("parquet.enable.dictionary", Boolean.valueOf(enableDictionaryPage).booleanValue());
        }
        if ((compressionName = tableProperties.getProperty("parquet.compression")) != null && !compressionName.isEmpty()) {
            LOG.debug((Object)"get override compression properties via tblproperties");
            CompressionCodecName codecName = CompressionCodecName.fromConf(compressionName);
            conf.set("parquet.compression", codecName.name());
        }
    }

    public void close(Reporter reporter) throws IOException {
        try {
            this.realWriter.close(this.taskContext);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void write(Void key, ParquetHiveRecord value) throws IOException {
        try {
            this.realWriter.write((Object)key, (Object)value);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close(boolean abort) throws IOException {
        this.close(null);
    }

    @Override
    public void write(Writable w) throws IOException {
        this.write(null, (ParquetHiveRecord)w);
    }
}

