/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.persistence.HybridHashTableContainer;

public class HybridHashTableConf {
    private List<HybridHashTableContainer> loadedContainerList = new ArrayList<HybridHashTableContainer>();
    private int numberOfPartitions = 0;
    private int nextSpillPartition = -1;

    public int getNumberOfPartitions() {
        return this.numberOfPartitions;
    }

    public void setNumberOfPartitions(int numberOfPartitions) {
        this.numberOfPartitions = numberOfPartitions;
        this.nextSpillPartition = numberOfPartitions - 1;
    }

    public int getNextSpillPartition() {
        return this.nextSpillPartition;
    }

    public void setNextSpillPartition(int nextSpillPartition) {
        this.nextSpillPartition = nextSpillPartition;
    }

    public List<HybridHashTableContainer> getLoadedContainerList() {
        return this.loadedContainerList;
    }

    public long spill() throws IOException {
        if (this.nextSpillPartition == 0) {
            return 0L;
        }
        long memFreed = 0L;
        for (HybridHashTableContainer container : this.loadedContainerList) {
            memFreed += container.spillPartition(this.nextSpillPartition);
            container.setSpill(true);
        }
        --this.nextSpillPartition;
        return memFreed;
    }

    public boolean doSpillOnCreation(int partitionId) {
        return this.nextSpillPartition != -1 && partitionId > this.nextSpillPartition;
    }
}

