/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.descriptors;

import java.util.Map;
import org.apache.flink.table.descriptors.CatalogDescriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class HiveCatalogDescriptor
extends CatalogDescriptor {
    private String hiveSitePath;
    private String hiveVersion;

    public HiveCatalogDescriptor() {
        super("hive", 1);
    }

    public HiveCatalogDescriptor hiveSitePath(String hiveSitePath) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)hiveSitePath) ? 1 : 0) != 0);
        this.hiveSitePath = hiveSitePath;
        return this;
    }

    public HiveCatalogDescriptor hiveVersion(String hiveVersion) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)hiveVersion) ? 1 : 0) != 0);
        this.hiveVersion = hiveVersion;
        return this;
    }

    protected Map<String, String> toCatalogProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        if (this.hiveSitePath != null) {
            properties.putString("hive-conf-dir", this.hiveSitePath);
        }
        if (this.hiveVersion != null) {
            properties.putString("hive-version", this.hiveVersion);
        }
        return properties.asMap();
    }
}

