/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.client.HiveShimV111;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDate;
import org.apache.flink.table.catalog.stats.Date;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.thrift.TException;

public class HiveShimV120
extends HiveShimV111 {
    @Override
    public IMetaStoreClient getHiveMetastoreClient(HiveConf hiveConf) {
        try {
            Method method = RetryingMetaStoreClient.class.getMethod("getProxy", HiveConf.class);
            return (IMetaStoreClient)method.invoke(null, new Object[]{hiveConf});
        }
        catch (Exception ex) {
            throw new CatalogException("Failed to create Hive Metastore client", (Throwable)ex);
        }
    }

    @Override
    public void alterTable(IMetaStoreClient client, String databaseName, String tableName, Table table) throws InvalidOperationException, MetaException, TException {
        table.getParameters().put("DO_NOT_UPDATE_STATS", "true");
        client.alter_table(databaseName, tableName, table);
    }

    @Override
    public ColumnStatisticsData toHiveDateColStats(CatalogColumnStatisticsDataDate flinkDateColStats) {
        try {
            Class<?> dateStatsClz = Class.forName("org.apache.hadoop.hive.metastore.api.DateColumnStatsData");
            Object dateStats = dateStatsClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            dateStatsClz.getMethod("clear", new Class[0]).invoke(dateStats, new Object[0]);
            if (null != flinkDateColStats.getNdv()) {
                dateStatsClz.getMethod("setNumDVs", Long.TYPE).invoke(dateStats, flinkDateColStats.getNdv());
            }
            if (null != flinkDateColStats.getNullCount()) {
                dateStatsClz.getMethod("setNumNulls", Long.TYPE).invoke(dateStats, flinkDateColStats.getNullCount());
            }
            Class<?> hmsDateClz = Class.forName("org.apache.hadoop.hive.metastore.api.Date");
            Constructor<?> hmsDateConstructor = hmsDateClz.getConstructor(Long.TYPE);
            if (null != flinkDateColStats.getMax()) {
                Method setHigh = dateStatsClz.getDeclaredMethod("setHighValue", hmsDateClz);
                setHigh.invoke(dateStats, hmsDateConstructor.newInstance(flinkDateColStats.getMax().getDaysSinceEpoch()));
            }
            if (null != flinkDateColStats.getMin()) {
                Method setLow = dateStatsClz.getDeclaredMethod("setLowValue", hmsDateClz);
                setLow.invoke(dateStats, hmsDateConstructor.newInstance(flinkDateColStats.getMin().getDaysSinceEpoch()));
            }
            Class<ColumnStatisticsData> colStatsClz = ColumnStatisticsData.class;
            return (ColumnStatisticsData)colStatsClz.getDeclaredMethod("dateStats", dateStatsClz).invoke(null, dateStats);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CatalogException("Failed to create Hive statistics for date column", (Throwable)e);
        }
    }

    @Override
    public boolean isDateStats(ColumnStatisticsData colStatsData) {
        try {
            Method method = ColumnStatisticsData.class.getDeclaredMethod("isSetDateStats", new Class[0]);
            return (Boolean)method.invoke((Object)colStatsData, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CatalogException("Failed to decide whether ColumnStatisticsData is for DATE column", (Throwable)e);
        }
    }

    @Override
    public CatalogColumnStatisticsDataDate toFlinkDateColStats(ColumnStatisticsData hiveDateColStats) {
        try {
            Object dateStats = ColumnStatisticsData.class.getDeclaredMethod("getDateStats", new Class[0]).invoke((Object)hiveDateColStats, new Object[0]);
            Class<?> dateStatsClz = dateStats.getClass();
            boolean isSetNumDv = (Boolean)dateStatsClz.getMethod("isSetNumDVs", new Class[0]).invoke(dateStats, new Object[0]);
            boolean isSetNumNull = (Boolean)dateStatsClz.getMethod("isSetNumNulls", new Class[0]).invoke(dateStats, new Object[0]);
            boolean isSetHighValue = (Boolean)dateStatsClz.getMethod("isSetHighValue", new Class[0]).invoke(dateStats, new Object[0]);
            boolean isSetLowValue = (Boolean)dateStatsClz.getMethod("isSetLowValue", new Class[0]).invoke(dateStats, new Object[0]);
            Long numDV = isSetNumDv ? (Long)dateStatsClz.getMethod("getNumDVs", new Class[0]).invoke(dateStats, new Object[0]) : null;
            Long numNull = isSetNumNull ? (Long)dateStatsClz.getMethod("getNumNulls", new Class[0]).invoke(dateStats, new Object[0]) : null;
            Object hmsHighDate = dateStatsClz.getMethod("getHighValue", new Class[0]).invoke(dateStats, new Object[0]);
            Object hmsLowDate = dateStatsClz.getMethod("getLowValue", new Class[0]).invoke(dateStats, new Object[0]);
            Class<?> hmsDateClz = hmsHighDate.getClass();
            Method hmsDateDays = hmsDateClz.getMethod("getDaysSinceEpoch", new Class[0]);
            Date highDateDays = isSetHighValue ? new Date(((Long)hmsDateDays.invoke(hmsHighDate, new Object[0])).longValue()) : null;
            Date lowDateDays = isSetLowValue ? new Date(((Long)hmsDateDays.invoke(hmsLowDate, new Object[0])).longValue()) : null;
            return new CatalogColumnStatisticsDataDate(lowDateDays, highDateDays, numDV, numNull);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CatalogException("Failed to create Flink statistics for date column", (Throwable)e);
        }
    }

    @Override
    public Set<String> listBuiltInFunctions() {
        try {
            Method method = FunctionRegistry.class.getMethod("getFunctionNames", new Class[0]);
            Set names = (Set)method.invoke(null, new Object[0]);
            return names.stream().filter(n -> this.getBuiltInFunctionInfo((String)n).isPresent()).collect(Collectors.toSet());
        }
        catch (Exception ex) {
            throw new CatalogException("Failed to invoke FunctionRegistry.getFunctionNames()", (Throwable)ex);
        }
    }

    @Override
    public Optional<FunctionInfo> getBuiltInFunctionInfo(String name) {
        if (HiveShimV120.isCatalogFunctionName(name)) {
            return Optional.empty();
        }
        try {
            Optional<FunctionInfo> functionInfo = Optional.ofNullable(FunctionRegistry.getFunctionInfo(name));
            if (functionInfo.isPresent() && this.isBuiltInFunctionInfo(functionInfo.get())) {
                return functionInfo;
            }
            return Optional.empty();
        }
        catch (SemanticException e) {
            throw new FlinkHiveException(String.format("Failed getting function info for %s", name), e);
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    private static boolean isCatalogFunctionName(String funcName) {
        return FunctionUtils.isQualifiedFunctionName(funcName);
    }

    private boolean isBuiltInFunctionInfo(FunctionInfo info) {
        try {
            Method method = FunctionInfo.class.getMethod("isBuiltIn", null);
            return (Boolean)method.invoke((Object)info, new Object[0]);
        }
        catch (Exception ex) {
            throw new CatalogException("Failed to invoke FunctionInfo.isBuiltIn()", (Throwable)ex);
        }
    }
}

