/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.shim.OrcShim;
import org.apache.flink.orc.vector.OrcVectorizedBatchWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;

public abstract class OrcSplitReader<T, BATCH>
implements Closeable {
    private final OrcShim<BATCH> shim;
    private RecordReader orcRowsReader;
    protected final OrcVectorizedBatchWrapper<BATCH> rowBatchWrapper;
    private int rowsInBatch;
    protected int nextRow;

    public OrcSplitReader(OrcShim<BATCH> shim, Configuration conf, TypeDescription schema, int[] selectedFields, List<Predicate> conjunctPredicates, int batchSize, Path path, long splitStart, long splitLength) throws IOException {
        this.shim = shim;
        this.orcRowsReader = shim.createRecordReader(conf, schema, selectedFields, conjunctPredicates, path, splitStart, splitLength);
        this.rowBatchWrapper = shim.createBatchWrapper(schema, batchSize);
        this.rowsInBatch = 0;
        this.nextRow = 0;
    }

    public void seekToRow(long rowCount) throws IOException {
        this.orcRowsReader.seekToRow(rowCount);
    }

    @VisibleForTesting
    public RecordReader getRecordReader() {
        return this.orcRowsReader;
    }

    public boolean reachedEnd() throws IOException {
        return !this.ensureBatch();
    }

    protected abstract int fillRows();

    public abstract T nextRecord(T var1) throws IOException;

    private boolean ensureBatch() throws IOException {
        if (this.nextRow >= this.rowsInBatch) {
            this.nextRow = 0;
            boolean moreRows = this.shim.nextBatch(this.orcRowsReader, this.rowBatchWrapper.getBatch());
            if (moreRows) {
                this.rowsInBatch = this.fillRows();
            }
            return moreRows;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.orcRowsReader != null) {
            this.orcRowsReader.close();
        }
        this.orcRowsReader = null;
    }

    public static class Or
    extends Predicate {
        private final Predicate[] preds;

        public Or(Predicate ... predicates) {
            this.preds = predicates;
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            SearchArgument.Builder withOr = builder.startOr();
            for (Predicate p : this.preds) {
                withOr = p.add(withOr);
            }
            return withOr.end();
        }

        protected Iterable<Predicate> children() {
            return Arrays.asList(this.preds);
        }

        public String toString() {
            return "OR(" + Arrays.toString(this.preds) + ")";
        }
    }

    public static class Not
    extends Predicate {
        private final Predicate pred;

        public Not(Predicate predicate) {
            this.pred = predicate;
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return this.pred.add(builder.startNot()).end();
        }

        protected Predicate child() {
            return this.pred;
        }

        public String toString() {
            return "NOT(" + this.pred.toString() + ")";
        }
    }

    public static class In
    extends ColumnPredicate {
        private Serializable[] literals;

        public In(String columnName, PredicateLeaf.Type literalType, Serializable ... literals) {
            super(columnName, literalType);
            this.literals = literals;
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            Object[] castedLiterals = new Object[this.literals.length];
            for (int i = 0; i < this.literals.length; ++i) {
                castedLiterals[i] = this.castLiteral(this.literals[i]);
            }
            return builder.in(this.columnName, this.literalType, castedLiterals);
        }

        public String toString() {
            return this.columnName + " IN " + Arrays.toString(this.literals);
        }
    }

    public static class Between
    extends ColumnPredicate {
        private Serializable lowerBound;
        private Serializable upperBound;

        public Between(String columnName, PredicateLeaf.Type literalType, Serializable lowerBound, Serializable upperBound) {
            super(columnName, literalType);
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.between(this.columnName, this.literalType, this.castLiteral(this.lowerBound), this.castLiteral(this.upperBound));
        }

        public String toString() {
            return this.lowerBound + " <= " + this.columnName + " <= " + this.upperBound;
        }
    }

    public static class IsNull
    extends ColumnPredicate {
        public IsNull(String columnName, PredicateLeaf.Type literalType) {
            super(columnName, literalType);
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.isNull(this.columnName, this.literalType);
        }

        public String toString() {
            return this.columnName + " IS NULL";
        }
    }

    public static class LessThanEquals
    extends BinaryPredicate {
        public LessThanEquals(String columnName, PredicateLeaf.Type literalType, Serializable literal) {
            super(columnName, literalType, literal);
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.lessThanEquals(this.columnName, this.literalType, this.castLiteral(this.literal));
        }

        public String toString() {
            return this.columnName + " <= " + this.literal;
        }
    }

    public static class LessThan
    extends BinaryPredicate {
        public LessThan(String columnName, PredicateLeaf.Type literalType, Serializable literal) {
            super(columnName, literalType, literal);
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.lessThan(this.columnName, this.literalType, this.castLiteral(this.literal));
        }

        public String toString() {
            return this.columnName + " < " + this.literal;
        }
    }

    public static class NullSafeEquals
    extends BinaryPredicate {
        public NullSafeEquals(String columnName, PredicateLeaf.Type literalType, Serializable literal) {
            super(columnName, literalType, literal);
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.nullSafeEquals(this.columnName, this.literalType, this.castLiteral(this.literal));
        }

        public String toString() {
            return this.columnName + " = " + this.literal;
        }
    }

    public static class Equals
    extends BinaryPredicate {
        public Equals(String columnName, PredicateLeaf.Type literalType, Serializable literal) {
            super(columnName, literalType, literal);
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.equals(this.columnName, this.literalType, this.castLiteral(this.literal));
        }

        public String toString() {
            return this.columnName + " = " + this.literal;
        }
    }

    static abstract class BinaryPredicate
    extends ColumnPredicate {
        final Serializable literal;

        BinaryPredicate(String columnName, PredicateLeaf.Type literalType, Serializable literal) {
            super(columnName, literalType);
            this.literal = literal;
        }
    }

    static abstract class ColumnPredicate
    extends Predicate {
        final String columnName;
        final PredicateLeaf.Type literalType;

        ColumnPredicate(String columnName, PredicateLeaf.Type literalType) {
            this.columnName = columnName;
            this.literalType = literalType;
        }

        Object castLiteral(Serializable literal) {
            switch (this.literalType) {
                case LONG: {
                    if (literal instanceof Byte) {
                        return new Long(((Byte)literal).byteValue());
                    }
                    if (literal instanceof Short) {
                        return new Long(((Short)literal).shortValue());
                    }
                    if (literal instanceof Integer) {
                        return new Long(((Integer)literal).intValue());
                    }
                    if (literal instanceof Long) {
                        return literal;
                    }
                    throw new IllegalArgumentException("A predicate on a LONG column requires an integer literal, i.e., Byte, Short, Integer, or Long.");
                }
                case FLOAT: {
                    if (literal instanceof Float) {
                        return new Double(((Float)literal).floatValue());
                    }
                    if (literal instanceof Double) {
                        return literal;
                    }
                    if (literal instanceof BigDecimal) {
                        return ((BigDecimal)literal).doubleValue();
                    }
                    throw new IllegalArgumentException("A predicate on a FLOAT column requires a floating literal, i.e., Float or Double.");
                }
                case STRING: {
                    if (literal instanceof String) {
                        return literal;
                    }
                    throw new IllegalArgumentException("A predicate on a STRING column requires a floating literal, i.e., Float or Double.");
                }
                case BOOLEAN: {
                    if (literal instanceof Boolean) {
                        return literal;
                    }
                    throw new IllegalArgumentException("A predicate on a BOOLEAN column requires a Boolean literal.");
                }
                case DATE: {
                    if (literal instanceof Date) {
                        return literal;
                    }
                    throw new IllegalArgumentException("A predicate on a DATE column requires a java.sql.Date literal.");
                }
                case TIMESTAMP: {
                    if (literal instanceof Timestamp) {
                        return literal;
                    }
                    throw new IllegalArgumentException("A predicate on a TIMESTAMP column requires a java.sql.Timestamp literal.");
                }
                case DECIMAL: {
                    if (literal instanceof BigDecimal) {
                        return new HiveDecimalWritable(HiveDecimal.create((BigDecimal)literal));
                    }
                    throw new IllegalArgumentException("A predicate on a DECIMAL column requires a BigDecimal literal.");
                }
            }
            throw new IllegalArgumentException("Unknown literal type " + (Object)((Object)this.literalType));
        }
    }

    public static abstract class Predicate
    implements Serializable {
        public abstract SearchArgument.Builder add(SearchArgument.Builder var1);
    }
}

