/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.AbstractPositionedByteRange;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
@SuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class SimplePositionedMutableByteRange
extends AbstractPositionedByteRange {
    public SimplePositionedMutableByteRange() {
    }

    public SimplePositionedMutableByteRange(int capacity) {
        this(new byte[capacity]);
    }

    public SimplePositionedMutableByteRange(byte[] bytes) {
        this.set(bytes);
    }

    public SimplePositionedMutableByteRange(byte[] bytes, int offset, int length) {
        this.set(bytes, offset, length);
    }

    @Override
    public PositionedByteRange unset() {
        this.position = 0;
        this.clearHashCache();
        this.bytes = null;
        this.offset = 0;
        this.length = 0;
        return this;
    }

    @Override
    public PositionedByteRange set(int capacity) {
        this.position = 0;
        super.set(capacity);
        this.limit = capacity;
        return this;
    }

    @Override
    public PositionedByteRange set(byte[] bytes) {
        this.position = 0;
        super.set(bytes);
        this.limit = bytes.length;
        return this;
    }

    @Override
    public PositionedByteRange set(byte[] bytes, int offset, int length) {
        this.position = 0;
        super.set(bytes, offset, length);
        this.limit = length;
        return this;
    }

    @Override
    public PositionedByteRange setOffset(int offset) {
        this.position = 0;
        super.setOffset(offset);
        return this;
    }

    @Override
    public PositionedByteRange setLength(int length) {
        this.position = Math.min(this.position, length);
        super.setLength(length);
        return this;
    }

    @Override
    public PositionedByteRange put(byte val) {
        this.put(this.position++, val);
        return this;
    }

    @Override
    public PositionedByteRange put(byte[] val) {
        if (0 == val.length) {
            return this;
        }
        return this.put(val, 0, val.length);
    }

    @Override
    public PositionedByteRange put(byte[] val, int offset, int length) {
        if (0 == length) {
            return this;
        }
        this.put(this.position, val, offset, length);
        this.position += length;
        return this;
    }

    @Override
    public PositionedByteRange get(int index, byte[] dst) {
        super.get(index, dst);
        return this;
    }

    @Override
    public PositionedByteRange get(int index, byte[] dst, int offset, int length) {
        super.get(index, dst, offset, length);
        return this;
    }

    @Override
    public PositionedByteRange put(int index, byte val) {
        this.bytes[this.offset + index] = val;
        return this;
    }

    @Override
    public PositionedByteRange put(int index, byte[] val) {
        if (0 == val.length) {
            return this;
        }
        return this.put(index, val, 0, val.length);
    }

    @Override
    public PositionedByteRange put(int index, byte[] val, int offset, int length) {
        if (0 == length) {
            return this;
        }
        System.arraycopy(val, offset, this.bytes, this.offset + index, length);
        return this;
    }

    @Override
    public PositionedByteRange deepCopy() {
        SimplePositionedMutableByteRange clone = new SimplePositionedMutableByteRange(this.deepCopyToNewArray());
        clone.position = this.position;
        return clone;
    }

    @Override
    public PositionedByteRange shallowCopy() {
        SimplePositionedMutableByteRange clone = new SimplePositionedMutableByteRange(this.bytes, this.offset, this.length);
        clone.position = this.position;
        return clone;
    }

    @Override
    public PositionedByteRange shallowCopySubRange(int innerOffset, int copyLength) {
        SimplePositionedMutableByteRange clone = new SimplePositionedMutableByteRange(this.bytes, this.offset + innerOffset, copyLength);
        clone.position = this.position;
        return clone;
    }

    @Override
    public PositionedByteRange putShort(short val) {
        this.putShort(this.position, val);
        this.position += 2;
        return this;
    }

    @Override
    public PositionedByteRange putInt(int val) {
        this.putInt(this.position, val);
        this.position += 4;
        return this;
    }

    @Override
    public PositionedByteRange putLong(long val) {
        this.putLong(this.position, val);
        this.position += 8;
        return this;
    }

    @Override
    public int putVLong(long val) {
        int len = this.putVLong(this.position, val);
        this.position += len;
        return len;
    }

    @Override
    public PositionedByteRange putShort(int index, short val) {
        this.bytes[this.offset + index + 1] = (byte)val;
        val = (short)(val >> 8);
        this.bytes[this.offset + index] = (byte)val;
        this.clearHashCache();
        return this;
    }

    @Override
    public PositionedByteRange putInt(int index, int val) {
        for (int i = 3; i > 0; --i) {
            this.bytes[this.offset + index + i] = (byte)val;
            val >>>= 8;
        }
        this.bytes[this.offset + index] = (byte)val;
        this.clearHashCache();
        return this;
    }

    @Override
    public PositionedByteRange putLong(int index, long val) {
        for (int i = 7; i > 0; --i) {
            this.bytes[this.offset + index + i] = (byte)val;
            val >>>= 8;
        }
        this.bytes[this.offset + index] = (byte)val;
        this.clearHashCache();
        return this;
    }

    @Override
    public int putVLong(int index, long val) {
        int rPos = 0;
        while (true) {
            if ((val & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.bytes[this.offset + index + rPos] = (byte)(val & 0x7FL | 0x80L);
            val >>>= 7;
            ++rPos;
        }
        this.bytes[this.offset + index + rPos] = (byte)val;
        this.clearHashCache();
        return rPos + 1;
    }
}

