/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.io;

import java.io.InputStream;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ByteBuffInputStream
extends InputStream {
    private ByteBuff buf;

    public ByteBuffInputStream(ByteBuff buf) {
        this.buf = buf;
    }

    @Override
    public int read() {
        if (this.buf.hasRemaining()) {
            return this.buf.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int avail = this.available();
        if (avail <= 0) {
            return -1;
        }
        if (len <= 0) {
            return 0;
        }
        if (len > avail) {
            len = avail;
        }
        this.buf.get(b, off, len);
        return len;
    }

    @Override
    public long skip(long n) {
        long k = Math.min(n, (long)this.available());
        if (k <= 0L) {
            return 0L;
        }
        this.buf.skip((int)k);
        return k;
    }

    @Override
    public int available() {
        return this.buf.remaining();
    }
}

