/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase2;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.hbase.options.HBaseLookupOptions;
import org.apache.flink.connector.hbase.options.HBaseWriteOptions;
import org.apache.flink.connector.hbase.table.HBaseConnectorOptions;
import org.apache.flink.connector.hbase.table.HBaseConnectorOptionsUtil;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.connector.hbase2.sink.HBaseDynamicTableSink;
import org.apache.flink.connector.hbase2.source.HBaseDynamicTableSource;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.hadoop.conf.Configuration;

@Internal
public class HBase2DynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    private static final String IDENTIFIER = "hbase-2.2";

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"properties."});
        ReadableConfig tableOptions = helper.getOptions();
        TableSchema tableSchema = context.getCatalogTable().getSchema();
        Map options = context.getCatalogTable().getOptions();
        HBaseConnectorOptionsUtil.validatePrimaryKey(tableSchema);
        String tableName = (String)tableOptions.get(HBaseConnectorOptions.TABLE_NAME);
        Configuration hbaseConf = HBaseConnectorOptionsUtil.getHBaseConfiguration(options);
        HBaseLookupOptions lookupOptions = HBaseConnectorOptionsUtil.getHBaseLookupOptions(tableOptions);
        String nullStringLiteral = (String)tableOptions.get(HBaseConnectorOptions.NULL_STRING_LITERAL);
        HBaseTableSchema hbaseSchema = HBaseTableSchema.fromTableSchema(tableSchema);
        return new HBaseDynamicTableSource(hbaseConf, tableName, hbaseSchema, nullStringLiteral, lookupOptions);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"properties."});
        ReadableConfig tableOptions = helper.getOptions();
        TableSchema tableSchema = context.getCatalogTable().getSchema();
        Map options = context.getCatalogTable().getOptions();
        HBaseConnectorOptionsUtil.validatePrimaryKey(tableSchema);
        String tableName = (String)tableOptions.get(HBaseConnectorOptions.TABLE_NAME);
        Configuration hbaseConf = HBaseConnectorOptionsUtil.getHBaseConfiguration(options);
        HBaseWriteOptions hBaseWriteOptions = HBaseConnectorOptionsUtil.getHBaseWriteOptions(tableOptions);
        String nullStringLiteral = (String)tableOptions.get(HBaseConnectorOptions.NULL_STRING_LITERAL);
        HBaseTableSchema hbaseSchema = HBaseTableSchema.fromTableSchema(tableSchema);
        return new HBaseDynamicTableSink(tableName, hbaseSchema, hbaseConf, hBaseWriteOptions, nullStringLiteral);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet set = new HashSet();
        set.add(HBaseConnectorOptions.TABLE_NAME);
        return set;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet set = new HashSet();
        set.add(HBaseConnectorOptions.ZOOKEEPER_ZNODE_PARENT);
        set.add(HBaseConnectorOptions.ZOOKEEPER_QUORUM);
        set.add(HBaseConnectorOptions.NULL_STRING_LITERAL);
        set.add(HBaseConnectorOptions.SINK_BUFFER_FLUSH_MAX_SIZE);
        set.add(HBaseConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        set.add(HBaseConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL);
        set.add(HBaseConnectorOptions.SINK_PARALLELISM);
        set.add(HBaseConnectorOptions.LOOKUP_ASYNC);
        set.add(HBaseConnectorOptions.LOOKUP_CACHE_MAX_ROWS);
        set.add(HBaseConnectorOptions.LOOKUP_CACHE_TTL);
        set.add(HBaseConnectorOptions.LOOKUP_MAX_RETRIES);
        return set;
    }
}

