/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.htrace.shaded.fasterxml.jackson.annotation;

import java.util.UUID;
import org.apache.flink.hbase.shaded.org.apache.htrace.shaded.fasterxml.jackson.annotation.ObjectIdGenerator;

public class ObjectIdGenerators {

    public static final class UUIDGenerator
    extends Base<UUID> {
        private static final long serialVersionUID = 1L;

        public UUIDGenerator() {
            this(Object.class);
        }

        private UUIDGenerator(Class<?> scope) {
            super(Object.class);
        }

        @Override
        public ObjectIdGenerator<UUID> forScope(Class<?> scope) {
            return this;
        }

        @Override
        public ObjectIdGenerator<UUID> newForSerialization(Object context) {
            return this;
        }

        @Override
        public UUID generateId(Object forPojo) {
            return UUID.randomUUID();
        }

        @Override
        public ObjectIdGenerator.IdKey key(Object key) {
            return new ObjectIdGenerator.IdKey(this.getClass(), null, key);
        }

        @Override
        public boolean canUseFor(ObjectIdGenerator<?> gen) {
            return gen.getClass() == this.getClass();
        }
    }

    public static final class IntSequenceGenerator
    extends Base<Integer> {
        private static final long serialVersionUID = 1L;
        protected transient int _nextValue;

        public IntSequenceGenerator() {
            this(Object.class, -1);
        }

        public IntSequenceGenerator(Class<?> scope, int fv) {
            super(scope);
            this._nextValue = fv;
        }

        protected int initialValue() {
            return 1;
        }

        @Override
        public ObjectIdGenerator<Integer> forScope(Class<?> scope) {
            return this._scope == scope ? this : new IntSequenceGenerator(scope, this._nextValue);
        }

        @Override
        public ObjectIdGenerator<Integer> newForSerialization(Object context) {
            return new IntSequenceGenerator(this._scope, this.initialValue());
        }

        @Override
        public ObjectIdGenerator.IdKey key(Object key) {
            return new ObjectIdGenerator.IdKey(this.getClass(), this._scope, key);
        }

        @Override
        public Integer generateId(Object forPojo) {
            int id = this._nextValue++;
            return id;
        }
    }

    public static abstract class PropertyGenerator
    extends Base<Object> {
        private static final long serialVersionUID = 1L;

        protected PropertyGenerator(Class<?> scope) {
            super(scope);
        }
    }

    public static abstract class None
    extends ObjectIdGenerator<Object> {
    }

    private static abstract class Base<T>
    extends ObjectIdGenerator<T> {
        protected final Class<?> _scope;

        protected Base(Class<?> scope) {
            this._scope = scope;
        }

        @Override
        public final Class<?> getScope() {
            return this._scope;
        }

        @Override
        public boolean canUseFor(ObjectIdGenerator<?> gen) {
            return gen.getClass() == this.getClass() && gen.getScope() == this._scope;
        }

        @Override
        public abstract T generateId(Object var1);
    }
}

