/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.htrace.core;

import java.util.concurrent.Callable;
import org.apache.flink.hbase.shaded.org.apache.htrace.core.SpanId;
import org.apache.flink.hbase.shaded.org.apache.htrace.core.TraceScope;
import org.apache.flink.hbase.shaded.org.apache.htrace.core.Tracer;

public class TraceCallable<V>
implements Callable<V> {
    private final Tracer tracer;
    private final Callable<V> impl;
    private final SpanId parentId;
    private final String description;

    public TraceCallable(Tracer tracer, SpanId parentId, Callable<V> impl, String description) {
        this.tracer = tracer;
        this.impl = impl;
        this.parentId = parentId;
        this.description = description;
    }

    @Override
    public V call() throws Exception {
        String description = this.description;
        if (description == null) {
            description = Thread.currentThread().getName();
        }
        try (TraceScope chunk = this.tracer.newScope(description, this.parentId);){
            V v = this.impl.call();
            return v;
        }
    }

    public Callable<V> getImpl() {
        return this.impl;
    }
}

