/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.htrace.core;

import java.util.concurrent.ThreadLocalRandom;

public final class SpanId
implements Comparable<SpanId> {
    private static final int SPAN_ID_STRING_LENGTH = 32;
    private final long high;
    private final long low;
    public static SpanId INVALID = new SpanId(0L, 0L);

    private static long nonZeroRand64() {
        long r;
        while ((r = ThreadLocalRandom.current().nextLong()) == 0L) {
        }
        return r;
    }

    public static SpanId fromRandom() {
        return new SpanId(SpanId.nonZeroRand64(), SpanId.nonZeroRand64());
    }

    public static SpanId fromString(String str) {
        if (str.length() != 32) {
            throw new RuntimeException("Invalid SpanID string: length was not 32");
        }
        long high = Long.parseLong(str.substring(0, 8), 16) << 32 | Long.parseLong(str.substring(8, 16), 16);
        long low = Long.parseLong(str.substring(16, 24), 16) << 32 | Long.parseLong(str.substring(24, 32), 16);
        return new SpanId(high, low);
    }

    public SpanId(long high, long low) {
        this.high = high;
        this.low = low;
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SpanId)) {
            return false;
        }
        SpanId other = (SpanId)o;
        return other.high == this.high && other.low == this.low;
    }

    @Override
    public int compareTo(SpanId other) {
        int cmp = SpanId.compareAsUnsigned(this.high, other.high);
        if (cmp != 0) {
            return cmp;
        }
        return SpanId.compareAsUnsigned(this.low, other.low);
    }

    private static int compareAsUnsigned(long a, long b) {
        boolean bSign;
        boolean aSign = a < 0L;
        boolean bl = bSign = b < 0L;
        if (aSign != bSign) {
            if (aSign) {
                return 1;
            }
            return -1;
        }
        if (aSign) {
            a = -a;
            b = -b;
        }
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return (int)(0xFFFFFFFFFFFFFFFFL & this.high >> 32) ^ (int)(0xFFFFFFFFFFFFFFFFL & this.high >> 0) ^ (int)(0xFFFFFFFFFFFFFFFFL & this.low >> 32) ^ (int)(0xFFFFFFFFFFFFFFFFL & this.low >> 0);
    }

    public String toString() {
        return String.format("%08x%08x%08x%08x", 0xFFFFFFFFL & this.high >> 32, 0xFFFFFFFFL & this.high, 0xFFFFFFFFL & this.low >> 32, 0xFFFFFFFFL & this.low);
    }

    public boolean isValid() {
        return this.high != 0L || this.low != 0L;
    }

    public SpanId newChildId() {
        return new SpanId(this.high, SpanId.nonZeroRand64());
    }
}

