/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.types;

import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.types.DataType;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Bytes;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Order;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class RawLong
implements DataType<Long> {
    @Override
    public boolean isOrderPreserving() {
        return false;
    }

    @Override
    public Order getOrder() {
        return null;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSkippable() {
        return true;
    }

    @Override
    public int encodedLength(Long val) {
        return 8;
    }

    @Override
    public Class<Long> encodedClass() {
        return Long.class;
    }

    @Override
    public int skip(PositionedByteRange src) {
        src.setPosition(src.getPosition() + 8);
        return 8;
    }

    @Override
    public Long decode(PositionedByteRange src) {
        long val = Bytes.toLong(src.getBytes(), src.getOffset() + src.getPosition());
        this.skip(src);
        return val;
    }

    @Override
    public int encode(PositionedByteRange dst, Long val) {
        Bytes.putLong(dst.getBytes(), dst.getOffset() + dst.getPosition(), val);
        return this.skip(dst);
    }

    public long decodeLong(byte[] buff, int offset) {
        return Bytes.toLong(buff, offset);
    }

    public int encodeLong(byte[] buff, int offset, long val) {
        return Bytes.putLong(buff, offset, val);
    }
}

