/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.quotas;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class QuotaFilter {
    private Set<QuotaType> types = new HashSet<QuotaType>();
    private boolean hasFilters = false;
    private String namespaceRegex;
    private String tableRegex;
    private String userRegex;
    private String regionServerRegex;

    public QuotaFilter setUserFilter(String regex) {
        this.userRegex = regex;
        this.hasFilters |= StringUtils.isNotEmpty(regex);
        return this;
    }

    public QuotaFilter setTableFilter(String regex) {
        this.tableRegex = regex;
        this.hasFilters |= StringUtils.isNotEmpty(regex);
        return this;
    }

    public QuotaFilter setNamespaceFilter(String regex) {
        this.namespaceRegex = regex;
        this.hasFilters |= StringUtils.isNotEmpty(regex);
        return this;
    }

    public QuotaFilter setRegionServerFilter(String regex) {
        this.regionServerRegex = regex;
        this.hasFilters |= StringUtils.isNotEmpty(regex);
        return this;
    }

    public QuotaFilter addTypeFilter(QuotaType type) {
        this.types.add(type);
        this.hasFilters |= true;
        return this;
    }

    public boolean isNull() {
        return !this.hasFilters;
    }

    public Set<QuotaType> getTypeFilters() {
        return this.types;
    }

    public String getNamespaceFilter() {
        return this.namespaceRegex;
    }

    public String getTableFilter() {
        return this.tableRegex;
    }

    public String getUserFilter() {
        return this.userRegex;
    }

    public String getRegionServerFilter() {
        return this.regionServerRegex;
    }
}

