/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc;

import java.util.List;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.CellScannable;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.CellScanner;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc.HBaseRpcControllerImpl;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RpcControllerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RpcControllerFactory.class);
    public static final String CUSTOM_CONTROLLER_CONF_KEY = "hbase.rpc.controllerfactory.class";
    protected final Configuration conf;

    public RpcControllerFactory(Configuration conf) {
        this.conf = conf;
    }

    public HBaseRpcController newController() {
        return new HBaseRpcControllerImpl();
    }

    public HBaseRpcController newController(CellScanner cellScanner) {
        return new HBaseRpcControllerImpl(cellScanner);
    }

    public HBaseRpcController newController(List<CellScannable> cellIterables) {
        return new HBaseRpcControllerImpl(cellIterables);
    }

    public static RpcControllerFactory instantiate(Configuration configuration) {
        String rpcControllerFactoryClazz = configuration.get(CUSTOM_CONTROLLER_CONF_KEY, RpcControllerFactory.class.getName());
        try {
            return (RpcControllerFactory)ReflectionUtils.instantiateWithCustomCtor(rpcControllerFactoryClazz, new Class[]{Configuration.class}, new Object[]{configuration});
        }
        catch (NoClassDefFoundError | UnsupportedOperationException ex) {
            String msg = "Cannot load configured \"hbase.rpc.controllerfactory.class\" (" + rpcControllerFactoryClazz + ") from hbase-site.xml, falling back to use default RpcControllerFactory";
            if (LOG.isDebugEnabled()) {
                LOG.warn(msg, ex);
            } else {
                LOG.warn(msg);
            }
            return new RpcControllerFactory(configuration);
        }
    }
}

