/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.io.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.io.crypto.CipherProvider;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.io.crypto.Context;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public abstract class Cipher {
    public static final int KEY_LENGTH = 16;
    public static final int KEY_LENGTH_BITS = 128;
    public static final int BLOCK_SIZE = 16;
    public static final int IV_LENGTH = 16;
    public static final String RNG_ALGORITHM_KEY = "hbase.crypto.algorithm.rng";
    public static final String RNG_PROVIDER_KEY = "hbase.crypto.algorithm.rng.provider";
    private final CipherProvider provider;

    public Cipher(CipherProvider provider) {
        this.provider = provider;
    }

    public CipherProvider getProvider() {
        return this.provider;
    }

    public abstract String getName();

    public abstract int getKeyLength();

    public abstract int getIvLength();

    public abstract Key getRandomKey();

    public abstract Encryptor getEncryptor();

    public abstract Decryptor getDecryptor();

    public abstract OutputStream createEncryptionStream(OutputStream var1, Context var2, byte[] var3) throws IOException;

    public abstract OutputStream createEncryptionStream(OutputStream var1, Encryptor var2) throws IOException;

    public abstract InputStream createDecryptionStream(InputStream var1, Context var2, byte[] var3) throws IOException;

    public abstract InputStream createDecryptionStream(InputStream var1, Decryptor var2) throws IOException;
}

