/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.AsyncBufferedMutator;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Mutation;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Put;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.io.netty.util.HashedWheelTimer;
import org.apache.hbase.thirdparty.io.netty.util.Timeout;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncBufferedMutatorImpl
implements AsyncBufferedMutator {
    private final HashedWheelTimer periodicalFlushTimer;
    private final AsyncTable<?> table;
    private final long writeBufferSize;
    private final long periodicFlushTimeoutNs;
    private final int maxKeyValueSize;
    private List<Mutation> mutations = new ArrayList<Mutation>();
    private List<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
    private long bufferedSize;
    private boolean closed;
    @VisibleForTesting
    Timeout periodicFlushTask;

    AsyncBufferedMutatorImpl(HashedWheelTimer periodicalFlushTimer, AsyncTable<?> table, long writeBufferSize, long periodicFlushTimeoutNs, int maxKeyValueSize) {
        this.periodicalFlushTimer = periodicalFlushTimer;
        this.table = table;
        this.writeBufferSize = writeBufferSize;
        this.periodicFlushTimeoutNs = periodicFlushTimeoutNs;
        this.maxKeyValueSize = maxKeyValueSize;
    }

    @Override
    public TableName getName() {
        return this.table.getName();
    }

    @Override
    public Configuration getConfiguration() {
        return this.table.getConfiguration();
    }

    @VisibleForTesting
    protected void internalFlush() {
        List<Mutation> toSend;
        if (this.periodicFlushTask != null) {
            this.periodicFlushTask.cancel();
            this.periodicFlushTask = null;
        }
        if ((toSend = this.mutations).isEmpty()) {
            return;
        }
        List<CompletableFuture<Void>> toComplete = this.futures;
        assert (toSend.size() == toComplete.size());
        this.mutations = new ArrayList<Mutation>();
        this.futures = new ArrayList<CompletableFuture<Void>>();
        this.bufferedSize = 0L;
        Iterator<CompletableFuture<Void>> toCompleteIter = toComplete.iterator();
        for (CompletableFuture future : this.table.batch(toSend)) {
            CompletableFuture<Void> toCompleteFuture = toCompleteIter.next();
            FutureUtils.addListener(future, (r, e) -> {
                if (e != null) {
                    toCompleteFuture.completeExceptionally((Throwable)e);
                } else {
                    toCompleteFuture.complete(null);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CompletableFuture<Void>> mutate(List<? extends Mutation> mutations) {
        List<CompletableFuture<Void>> futures = Stream.generate(CompletableFuture::new).limit(mutations.size()).collect(Collectors.toList());
        long heapSize = 0L;
        for (Mutation mutation : mutations) {
            heapSize += mutation.heapSize();
            if (!(mutation instanceof Put)) continue;
            ConnectionUtils.validatePut((Put)mutation, this.maxKeyValueSize);
        }
        AsyncBufferedMutatorImpl asyncBufferedMutatorImpl = this;
        synchronized (asyncBufferedMutatorImpl) {
            if (this.closed) {
                IOException iOException = new IOException("Already closed");
                futures.forEach(f -> f.completeExceptionally(ioe));
                return futures;
            }
            if (this.mutations.isEmpty() && this.periodicFlushTimeoutNs > 0L) {
                this.periodicFlushTask = this.periodicalFlushTimer.newTimeout(timeout -> {
                    AsyncBufferedMutatorImpl asyncBufferedMutatorImpl = this;
                    synchronized (asyncBufferedMutatorImpl) {
                        if (timeout == this.periodicFlushTask) {
                            this.periodicFlushTask = null;
                            this.internalFlush();
                        }
                    }
                }, this.periodicFlushTimeoutNs, TimeUnit.NANOSECONDS);
            }
            this.mutations.addAll(mutations);
            this.futures.addAll(futures);
            this.bufferedSize += heapSize;
            if (this.bufferedSize >= this.writeBufferSize) {
                this.internalFlush();
            }
        }
        return futures;
    }

    @Override
    public synchronized void flush() {
        this.internalFlush();
    }

    @Override
    public synchronized void close() {
        this.internalFlush();
        this.closed = true;
    }

    @Override
    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public long getPeriodicalFlushTimeout(TimeUnit unit) {
        return unit.convert(this.periodicFlushTimeoutNs, TimeUnit.NANOSECONDS);
    }
}

