/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase2.source;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.hbase.options.HBaseLookupOptions;
import org.apache.flink.connector.hbase.util.HBaseConfigurationUtil;
import org.apache.flink.connector.hbase.util.HBaseSerde;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Get;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Result;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ScanResultConsumer;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Threads;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.shaded.guava18.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava18.com.google.common.cache.CacheBuilder;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HBaseRowDataAsyncLookupFunction
extends AsyncTableFunction<RowData> {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseRowDataAsyncLookupFunction.class);
    private static final long serialVersionUID = 1L;
    private final String hTableName;
    private final byte[] serializedConfig;
    private final HBaseTableSchema hbaseTableSchema;
    private final String nullStringLiteral;
    private transient AsyncConnection asyncConnection;
    private transient AsyncTable<ScanResultConsumer> table;
    private transient HBaseSerde serde;
    private final long cacheMaxSize;
    private final long cacheExpireMs;
    private final int maxRetryTimes;
    private transient Cache<Object, RowData> cache;
    private static final int THREAD_POOL_SIZE = 16;

    public HBaseRowDataAsyncLookupFunction(Configuration configuration, String hTableName, HBaseTableSchema hbaseTableSchema, String nullStringLiteral, HBaseLookupOptions lookupOptions) {
        this.serializedConfig = HBaseConfigurationUtil.serializeConfiguration(configuration);
        this.hTableName = hTableName;
        this.hbaseTableSchema = hbaseTableSchema;
        this.nullStringLiteral = nullStringLiteral;
        this.cacheMaxSize = lookupOptions.getCacheMaxSize();
        this.cacheExpireMs = lookupOptions.getCacheExpireMs();
        this.maxRetryTimes = lookupOptions.getMaxRetryTimes();
    }

    public void open(FunctionContext context) {
        LOG.info("start open ...");
        ExecutorService threadPool = Executors.newFixedThreadPool(16, (ThreadFactory)new ExecutorThreadFactory("hbase-aysnc-lookup-worker", Threads.LOGGING_EXCEPTION_HANDLER));
        Configuration config = this.prepareRuntimeConfiguration();
        CompletableFuture<AsyncConnection> asyncConnectionFuture = ConnectionFactory.createAsyncConnection(config);
        try {
            this.asyncConnection = asyncConnectionFuture.get();
            this.table = this.asyncConnection.getTable(TableName.valueOf(this.hTableName), threadPool);
            Cache<Object, RowData> cache = this.cache = this.cacheMaxSize <= 0L || this.cacheExpireMs <= 0L ? null : CacheBuilder.newBuilder().recordStats().expireAfterWrite(this.cacheExpireMs, TimeUnit.MILLISECONDS).maximumSize(this.cacheMaxSize).build();
            if (this.cache != null && context != null) {
                context.getMetricGroup().gauge("lookupCacheHitRate", () -> this.cache.stats().hitRate());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Exception while creating connection to HBase.", (Throwable)e);
            throw new RuntimeException("Cannot create connection to HBase.", e);
        }
        this.serde = new HBaseSerde(this.hbaseTableSchema, this.nullStringLiteral);
        LOG.info("end open.");
    }

    public void eval(CompletableFuture<Collection<RowData>> future, Object rowKey) {
        RowData cacheRowData;
        int currentRetry = 0;
        if (this.cache != null && (cacheRowData = (RowData)this.cache.getIfPresent(rowKey)) != null) {
            if (cacheRowData.getArity() == 0) {
                future.complete(Collections.emptyList());
            } else {
                future.complete(Collections.singletonList(cacheRowData));
            }
            return;
        }
        this.fetchResult(future, currentRetry, rowKey);
    }

    private void fetchResult(CompletableFuture<Collection<RowData>> resultFuture, int currentRetry, Object rowKey) {
        Get get = this.serde.createGet(rowKey);
        CompletableFuture<Result> responseFuture = this.table.get(get);
        responseFuture.whenCompleteAsync((result, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof TableNotFoundException) {
                    LOG.error("Table '{}' not found ", (Object)this.hTableName, throwable);
                    resultFuture.completeExceptionally(new RuntimeException("HBase table '" + this.hTableName + "' not found.", (Throwable)throwable));
                } else {
                    LOG.error(String.format("HBase asyncLookup error, retry times = %d", currentRetry), throwable);
                    if (currentRetry >= this.maxRetryTimes) {
                        resultFuture.completeExceptionally((Throwable)throwable);
                    } else {
                        try {
                            Thread.sleep(1000 * currentRetry);
                        }
                        catch (InterruptedException e1) {
                            resultFuture.completeExceptionally(e1);
                        }
                        this.fetchResult(resultFuture, currentRetry + 1, rowKey);
                    }
                }
            } else if (result.isEmpty()) {
                resultFuture.complete(Collections.emptyList());
                if (this.cache != null) {
                    this.cache.put(rowKey, (Object)new GenericRowData(0));
                }
            } else if (this.cache != null) {
                RowData rowData = this.serde.convertToNewRow((Result)result);
                resultFuture.complete(Collections.singletonList(rowData));
                this.cache.put(rowKey, (Object)rowData);
            } else {
                resultFuture.complete(Collections.singletonList(this.serde.convertToNewRow((Result)result)));
            }
        });
    }

    private Configuration prepareRuntimeConfiguration() {
        Configuration runtimeConfig = HBaseConfigurationUtil.deserializeConfiguration(this.serializedConfig, HBaseConfigurationUtil.getHBaseConfiguration());
        if (StringUtils.isNullOrWhitespaceOnly((String)runtimeConfig.get("hbase.zookeeper.quorum"))) {
            LOG.error("can not connect to HBase without {} configuration", (Object)"hbase.zookeeper.quorum");
            throw new IllegalArgumentException("check HBase configuration failed, lost: 'hbase.zookeeper.quorum'!");
        }
        return runtimeConfig;
    }

    public void close() {
        LOG.info("start close ...");
        if (null != this.table) {
            this.table = null;
        }
        if (null != this.asyncConnection) {
            try {
                this.asyncConnection.close();
                this.asyncConnection = null;
            }
            catch (IOException e) {
                LOG.warn("exception when close connection", (Throwable)e);
            }
        }
        LOG.info("end close.");
    }

    @VisibleForTesting
    public String getHTableName() {
        return this.hTableName;
    }
}

