/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase2.source;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.connector.hbase.options.HBaseLookupOptions;
import org.apache.flink.connector.hbase.source.AbstractHBaseDynamicTableSource;
import org.apache.flink.connector.hbase.source.HBaseRowDataLookupFunction;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.connector.hbase2.source.HBaseRowDataAsyncLookupFunction;
import org.apache.flink.connector.hbase2.source.HBaseRowDataInputFormat;
import org.apache.flink.table.connector.source.AsyncTableFunctionProvider;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.TableFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;

@Internal
public class HBaseDynamicTableSource
extends AbstractHBaseDynamicTableSource {
    public HBaseDynamicTableSource(Configuration conf, String tableName, HBaseTableSchema hbaseSchema, String nullStringLiteral, HBaseLookupOptions lookupOptions) {
        super(conf, tableName, hbaseSchema, nullStringLiteral, lookupOptions);
    }

    @Override
    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext context) {
        Preconditions.checkArgument((context.getKeys().length == 1 && context.getKeys()[0].length == 1 ? 1 : 0) != 0, (Object)"Currently, HBase table can only be lookup by single rowkey.");
        Preconditions.checkArgument((boolean)this.hbaseSchema.getRowKeyName().isPresent(), (Object)"HBase schema must have a row key when used in lookup mode.");
        Preconditions.checkArgument((boolean)this.hbaseSchema.convertsToTableSchema().getTableColumn(context.getKeys()[0][0]).filter(f -> f.getName().equals(this.hbaseSchema.getRowKeyName().get())).isPresent(), (Object)"Currently, HBase table only supports lookup by rowkey field.");
        if (this.lookupOptions.getLookupAsync()) {
            return AsyncTableFunctionProvider.of((AsyncTableFunction)new HBaseRowDataAsyncLookupFunction(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral, this.lookupOptions));
        }
        return TableFunctionProvider.of((TableFunction)new HBaseRowDataLookupFunction(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral, this.lookupOptions));
    }

    public DynamicTableSource copy() {
        return new HBaseDynamicTableSource(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral, this.lookupOptions);
    }

    @Override
    protected InputFormat<RowData, ?> getInputFormat() {
        return new HBaseRowDataInputFormat(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral);
    }

    @VisibleForTesting
    public HBaseLookupOptions getLookupOptions() {
        return this.lookupOptions;
    }
}

