/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.util;

import java.nio.charset.Charset;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.connector.hbase.util.HBaseTypeUtils;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Delete;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Get;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Put;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Result;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Scan;
import org.apache.flink.types.Row;

@Internal
public class HBaseReadWriteHelper {
    private final byte[][] families;
    private final byte[][][] qualifiers;
    private final int[][] qualifierTypes;
    private final int rowKeyIndex;
    private final int rowKeyType;
    private final int fieldLength;
    private final Charset charset;
    private Row resultRow;
    private Row[] familyRows;

    public HBaseReadWriteHelper(HBaseTableSchema hbaseTableSchema) {
        this.families = hbaseTableSchema.getFamilyKeys();
        this.qualifiers = new byte[this.families.length][][];
        this.qualifierTypes = new int[this.families.length][];
        this.familyRows = new Row[this.families.length];
        String[] familyNames = hbaseTableSchema.getFamilyNames();
        for (int f = 0; f < this.families.length; ++f) {
            this.qualifiers[f] = hbaseTableSchema.getQualifierKeys(familyNames[f]);
            TypeInformation<?>[] typeInfos = hbaseTableSchema.getQualifierTypes(familyNames[f]);
            this.qualifierTypes[f] = new int[typeInfos.length];
            for (int i = 0; i < typeInfos.length; ++i) {
                this.qualifierTypes[f][i] = HBaseTypeUtils.getTypeIndex(typeInfos[i]);
            }
            this.familyRows[f] = new Row(typeInfos.length);
        }
        this.charset = Charset.forName(hbaseTableSchema.getStringCharset());
        this.rowKeyIndex = hbaseTableSchema.getRowKeyIndex();
        this.rowKeyType = hbaseTableSchema.getRowKeyTypeInfo().map(HBaseTypeUtils::getTypeIndex).orElse(-1);
        this.fieldLength = this.rowKeyIndex == -1 ? this.families.length : this.families.length + 1;
        this.resultRow = new Row(this.fieldLength);
    }

    public Get createGet(Object rowKey) {
        byte[] rowkey = HBaseTypeUtils.serializeFromObject(rowKey, this.rowKeyType, this.charset);
        Get get = new Get(rowkey);
        for (int f = 0; f < this.families.length; ++f) {
            byte[] family = this.families[f];
            for (byte[] qualifier : this.qualifiers[f]) {
                get.addColumn(family, qualifier);
            }
        }
        return get;
    }

    public Scan createScan() {
        Scan scan = new Scan();
        for (int f = 0; f < this.families.length; ++f) {
            byte[] family = this.families[f];
            for (int q = 0; q < this.qualifiers[f].length; ++q) {
                byte[] quantifier = this.qualifiers[f][q];
                scan.addColumn(family, quantifier);
            }
        }
        return scan;
    }

    public Row parseToRow(Result result) {
        if (this.rowKeyIndex == -1) {
            return this.parseToRow(result, null);
        }
        Object rowkey = HBaseTypeUtils.deserializeToObject(result.getRow(), this.rowKeyType, this.charset);
        return this.parseToRow(result, rowkey);
    }

    public Row parseToRow(Result result, Object rowKey) {
        for (int i = 0; i < this.fieldLength; ++i) {
            if (this.rowKeyIndex == i) {
                this.resultRow.setField(this.rowKeyIndex, rowKey);
                continue;
            }
            int f = this.rowKeyIndex != -1 && i > this.rowKeyIndex ? i - 1 : i;
            byte[] familyKey = this.families[f];
            Row familyRow = this.familyRows[f];
            for (int q = 0; q < this.qualifiers[f].length; ++q) {
                byte[] qualifier = this.qualifiers[f][q];
                int typeIdx = this.qualifierTypes[f][q];
                byte[] value = result.getValue(familyKey, qualifier);
                if (value != null) {
                    familyRow.setField(q, HBaseTypeUtils.deserializeToObject(value, typeIdx, this.charset));
                    continue;
                }
                familyRow.setField(q, null);
            }
            this.resultRow.setField(i, (Object)familyRow);
        }
        return this.resultRow;
    }

    public Put createPutMutation(Row row) {
        assert (this.rowKeyIndex != -1);
        byte[] rowkey = HBaseTypeUtils.serializeFromObject(row.getField(this.rowKeyIndex), this.rowKeyType, this.charset);
        Put put = new Put(rowkey);
        for (int i = 0; i < this.fieldLength; ++i) {
            if (i == this.rowKeyIndex) continue;
            int f = i > this.rowKeyIndex ? i - 1 : i;
            byte[] familyKey = this.families[f];
            Row familyRow = (Row)row.getField(i);
            for (int q = 0; q < this.qualifiers[f].length; ++q) {
                byte[] qualifier = this.qualifiers[f][q];
                int typeIdx = this.qualifierTypes[f][q];
                byte[] value = HBaseTypeUtils.serializeFromObject(familyRow.getField(q), typeIdx, this.charset);
                put.addColumn(familyKey, qualifier, value);
            }
        }
        return put;
    }

    public Delete createDeleteMutation(Row row) {
        assert (this.rowKeyIndex != -1);
        byte[] rowkey = HBaseTypeUtils.serializeFromObject(row.getField(this.rowKeyIndex), this.rowKeyType, this.charset);
        Delete delete = new Delete(rowkey);
        for (int i = 0; i < this.fieldLength; ++i) {
            if (i == this.rowKeyIndex) continue;
            int f = i > this.rowKeyIndex ? i - 1 : i;
            byte[] familyKey = this.families[f];
            for (int q = 0; q < this.qualifiers[f].length; ++q) {
                byte[] qualifier = this.qualifiers[f][q];
                delete.addColumn(familyKey, qualifier);
            }
        }
        return delete;
    }
}

