/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.options;

import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.hbase.options.HBaseLookupOptions;
import org.apache.flink.connector.hbase.options.HBaseWriteOptions;
import org.apache.flink.connector.hbase.util.HBaseConfigurationUtil;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.factories.FactoryUtil;

@Internal
public class HBaseOptions {
    public static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("The name of HBase table to connect.");
    public static final ConfigOption<String> ZOOKEEPER_QUORUM = ConfigOptions.key((String)"zookeeper.quorum").stringType().noDefaultValue().withDescription("The HBase Zookeeper quorum.");
    public static final ConfigOption<String> ZOOKEEPER_ZNODE_PARENT = ConfigOptions.key((String)"zookeeper.znode.parent").stringType().defaultValue((Object)"/hbase").withDescription("The root dir in Zookeeper for HBase cluster.");
    public static final ConfigOption<String> NULL_STRING_LITERAL = ConfigOptions.key((String)"null-string-literal").stringType().defaultValue((Object)"null").withDescription("Representation for null values for string fields. HBase source and sink encodes/decodes empty bytes as null values for all types except string type.");
    public static final ConfigOption<MemorySize> SINK_BUFFER_FLUSH_MAX_SIZE = ConfigOptions.key((String)"sink.buffer-flush.max-size").memoryType().defaultValue((Object)MemorySize.parse((String)"2mb")).withDescription("Writing option, maximum size in memory of buffered rows for each writing request. This can improve performance for writing data to HBase database, but may increase the latency. Can be set to '0' to disable it. ");
    public static final ConfigOption<Integer> SINK_BUFFER_FLUSH_MAX_ROWS = ConfigOptions.key((String)"sink.buffer-flush.max-rows").intType().defaultValue((Object)1000).withDescription("Writing option, maximum number of rows to buffer for each writing request. This can improve performance for writing data to HBase database, but may increase the latency. Can be set to '0' to disable it.");
    public static final ConfigOption<Duration> SINK_BUFFER_FLUSH_INTERVAL = ConfigOptions.key((String)"sink.buffer-flush.interval").durationType().defaultValue((Object)Duration.ofSeconds(1L)).withDescription("Writing option, the interval to flush any buffered rows. This can improve performance for writing data to HBase database, but may increase the latency. Can be set to '0' to disable it. Note, both 'sink.buffer-flush.max-size' and 'sink.buffer-flush.max-rows' can be set to '0' with the flush interval set allowing for complete async processing of buffered actions.");
    public static final ConfigOption<Boolean> LOOKUP_ASYNC = ConfigOptions.key((String)"lookup.async").booleanType().defaultValue((Object)false).withDescription("whether to set async lookup.");
    public static final ConfigOption<Long> LOOKUP_CACHE_MAX_ROWS = ConfigOptions.key((String)"lookup.cache.max-rows").longType().defaultValue((Object)-1L).withDescription("the max number of rows of lookup cache, over this value, the oldest rows will be eliminated. \"cache.max-rows\" and \"cache.ttl\" options must all be specified if any of them is specified. Cache is not enabled as default.");
    public static final ConfigOption<Duration> LOOKUP_CACHE_TTL = ConfigOptions.key((String)"lookup.cache.ttl").durationType().defaultValue((Object)Duration.ofSeconds(0L)).withDescription("the cache time to live.");
    public static final ConfigOption<Integer> LOOKUP_MAX_RETRIES = ConfigOptions.key((String)"lookup.max-retries").intType().defaultValue((Object)3).withDescription("the max retry times if lookup database failed.");
    public static final String PROPERTIES_PREFIX = "properties.";

    public static void validatePrimaryKey(TableSchema schema) {
        HBaseTableSchema hbaseSchema = HBaseTableSchema.fromTableSchema(schema);
        if (!hbaseSchema.getRowKeyName().isPresent()) {
            throw new IllegalArgumentException("HBase table requires to define a row key field. A row key field is defined as an atomic type, column families and qualifiers are defined as ROW type.");
        }
        schema.getPrimaryKey().ifPresent(k -> {
            if (k.getColumns().size() > 1) {
                throw new IllegalArgumentException("HBase table doesn't support a primary Key on multiple columns. The primary key of HBase table must be defined on row key field.");
            }
            if (!hbaseSchema.getRowKeyName().get().equals(k.getColumns().get(0))) {
                throw new IllegalArgumentException("Primary key of HBase table must be defined on the row key field. A row key field is defined as an atomic type, column families and qualifiers are defined as ROW type.");
            }
        });
    }

    public static HBaseWriteOptions getHBaseWriteOptions(ReadableConfig tableOptions) {
        HBaseWriteOptions.Builder builder = HBaseWriteOptions.builder();
        builder.setBufferFlushIntervalMillis(((Duration)tableOptions.get(SINK_BUFFER_FLUSH_INTERVAL)).toMillis());
        builder.setBufferFlushMaxRows(((Integer)tableOptions.get(SINK_BUFFER_FLUSH_MAX_ROWS)).intValue());
        builder.setBufferFlushMaxSizeInBytes(((MemorySize)tableOptions.get(SINK_BUFFER_FLUSH_MAX_SIZE)).getBytes());
        builder.setParallelism(tableOptions.getOptional(FactoryUtil.SINK_PARALLELISM).orElse(null));
        return builder.build();
    }

    public static HBaseLookupOptions getHBaseLookupOptions(ReadableConfig tableOptions) {
        HBaseLookupOptions.Builder builder = HBaseLookupOptions.builder();
        builder.setLookupAsync((Boolean)tableOptions.get(LOOKUP_ASYNC));
        builder.setMaxRetryTimes((Integer)tableOptions.get(LOOKUP_MAX_RETRIES));
        builder.setCacheExpireMs(((Duration)tableOptions.get(LOOKUP_CACHE_TTL)).toMillis());
        builder.setCacheMaxSize((Long)tableOptions.get(LOOKUP_CACHE_MAX_ROWS));
        return builder.build();
    }

    public static org.apache.hadoop.conf.Configuration getHBaseConfiguration(Map<String, String> options) {
        Configuration tableOptions = Configuration.fromMap(options);
        org.apache.hadoop.conf.Configuration hbaseClientConf = HBaseConfigurationUtil.getHBaseConfiguration();
        hbaseClientConf.set("hbase.zookeeper.quorum", tableOptions.getString(ZOOKEEPER_QUORUM));
        hbaseClientConf.set("zookeeper.znode.parent", tableOptions.getString(ZOOKEEPER_ZNODE_PARENT));
        Properties properties = HBaseOptions.getHBaseClientProperties(options);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> hbaseClientConf.set(k.toString(), v.toString())));
        return hbaseClientConf;
    }

    private static Properties getHBaseClientProperties(Map<String, String> tableOptions) {
        Properties hbaseProperties = new Properties();
        if (HBaseOptions.containsHBaseClientProperties(tableOptions)) {
            tableOptions.keySet().stream().filter(key -> key.startsWith(PROPERTIES_PREFIX)).forEach(key -> {
                String value = (String)tableOptions.get(key);
                String subKey = key.substring(PROPERTIES_PREFIX.length());
                hbaseProperties.put(subKey, value);
            });
        }
        return hbaseProperties;
    }

    private static boolean containsHBaseClientProperties(Map<String, String> tableOptions) {
        return tableOptions.keySet().stream().anyMatch(k -> k.startsWith(PROPERTIES_PREFIX));
    }
}

