/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.protobuf;

import org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistryLite;

final class ExtensionRegistryFactory {
    static final String FULL_REGISTRY_CLASS_NAME = "org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistry";
    static final Class<?> EXTENSION_REGISTRY_CLASS = ExtensionRegistryFactory.reflectExtensionRegistry();

    ExtensionRegistryFactory() {
    }

    static Class<?> reflectExtensionRegistry() {
        try {
            return Class.forName(FULL_REGISTRY_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static ExtensionRegistryLite create() {
        if (EXTENSION_REGISTRY_CLASS != null) {
            try {
                return ExtensionRegistryFactory.invokeSubclassFactory("newInstance");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ExtensionRegistryLite();
    }

    public static ExtensionRegistryLite createEmpty() {
        if (EXTENSION_REGISTRY_CLASS != null) {
            try {
                return ExtensionRegistryFactory.invokeSubclassFactory("getEmptyRegistry");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ExtensionRegistryLite.EMPTY_REGISTRY_LITE;
    }

    static boolean isFullRegistry(ExtensionRegistryLite registry) {
        return EXTENSION_REGISTRY_CLASS != null && EXTENSION_REGISTRY_CLASS.isAssignableFrom(registry.getClass());
    }

    private static final ExtensionRegistryLite invokeSubclassFactory(String methodName) throws Exception {
        return (ExtensionRegistryLite)EXTENSION_REGISTRY_CLASS.getDeclaredMethod(methodName, new Class[0]).invoke(null, new Object[0]);
    }
}

