/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.HConstants;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.RegionLocations;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Result;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HRegionLocator
implements RegionLocator {
    private final TableName tableName;
    private final ConnectionImplementation connection;

    public HRegionLocator(TableName tableName, ConnectionImplementation connection) {
        this.connection = connection;
        this.tableName = tableName;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public HRegionLocation getRegionLocation(byte[] row, int replicaId, boolean reload) throws IOException {
        return this.connection.locateRegion(this.tableName, row, !reload, true, replicaId).getRegionLocation(replicaId);
    }

    @Override
    public List<HRegionLocation> getRegionLocations(byte[] row, boolean reload) throws IOException {
        RegionLocations locs = this.connection.locateRegion(this.tableName, row, !reload, true, 0);
        return Arrays.asList(locs.getRegionLocations());
    }

    @Override
    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        ArrayList<HRegionLocation> regions = new ArrayList<HRegionLocation>();
        for (RegionLocations locations : this.listRegionLocations()) {
            for (HRegionLocation location : locations.getRegionLocations()) {
                regions.add(location);
            }
            this.connection.cacheLocation(this.tableName, locations);
        }
        return regions;
    }

    @Override
    public void clearRegionLocationCache() {
        this.connection.clearRegionCache(this.tableName);
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    private List<RegionLocations> listRegionLocations() throws IOException {
        if (TableName.isMetaTableName(this.tableName)) {
            return Collections.singletonList(this.connection.locateRegion(this.tableName, HConstants.EMPTY_START_ROW, false, true));
        }
        final ArrayList<RegionLocations> regions = new ArrayList<RegionLocations>();
        MetaTableAccessor.TableVisitorBase visitor = new MetaTableAccessor.TableVisitorBase(this.tableName){

            @Override
            public boolean visitInternal(Result result) throws IOException {
                RegionLocations locations = MetaTableAccessor.getRegionLocations(result);
                if (locations == null) {
                    return true;
                }
                regions.add(locations);
                return true;
            }
        };
        MetaTableAccessor.scanMetaForTableRegions(this.connection, visitor, this.tableName);
        return regions;
    }
}

