/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase;

import java.math.BigDecimal;
import java.util.Objects;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class Size
implements Comparable<Size> {
    public static final Size ZERO = new Size(0.0, Unit.KILOBYTE);
    private static final BigDecimal SCALE_BASE = BigDecimal.valueOf(1024.0);
    private final double value;
    private final Unit unit;

    public Size(double value, Unit unit) {
        if (value < 0.0) {
            throw new IllegalArgumentException("The value:" + value + " can't be negative");
        }
        this.value = value;
        this.unit = Preconditions.checkNotNull(unit);
    }

    public Unit getUnit() {
        return this.unit;
    }

    public long getLongValue() {
        return (long)this.value;
    }

    public double get() {
        return this.value;
    }

    public double get(Unit unit) {
        if (this.value == 0.0) {
            return this.value;
        }
        int diff = this.unit.getOrderOfSize() - unit.getOrderOfSize();
        if (diff == 0) {
            return this.value;
        }
        BigDecimal rval = BigDecimal.valueOf(this.value);
        for (int i = 0; i != Math.abs(diff); ++i) {
            rval = diff > 0 ? rval.multiply(SCALE_BASE) : rval.divide(SCALE_BASE);
        }
        return rval.doubleValue();
    }

    @Override
    public int compareTo(Size other) {
        int diff = this.unit.getOrderOfSize() - other.unit.getOrderOfSize();
        if (diff == 0) {
            return Double.compare(this.value, other.value);
        }
        BigDecimal thisValue = BigDecimal.valueOf(this.value);
        BigDecimal otherValue = BigDecimal.valueOf(other.value);
        if (diff > 0) {
            for (int i = 0; i != Math.abs(diff); ++i) {
                thisValue = thisValue.multiply(SCALE_BASE);
            }
        } else {
            for (int i = 0; i != Math.abs(diff); ++i) {
                otherValue = otherValue.multiply(SCALE_BASE);
            }
        }
        return thisValue.compareTo(otherValue);
    }

    public String toString() {
        return this.value + this.unit.getSimpleName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Size) {
            return this.compareTo((Size)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.unit});
    }

    public static enum Unit {
        PETABYTE(100, "PB"),
        TERABYTE(99, "TB"),
        GIGABYTE(98, "GB"),
        MEGABYTE(97, "MB"),
        KILOBYTE(96, "KB"),
        BYTE(95, "B");

        private final int orderOfSize;
        private final String simpleName;

        private Unit(int orderOfSize, String simpleName) {
            this.orderOfSize = orderOfSize;
            this.simpleName = simpleName;
        }

        public int getOrderOfSize() {
            return this.orderOfSize;
        }

        public String getSimpleName() {
            return this.simpleName;
        }
    }
}

