/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.table;

import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.hbase.options.HBaseWriteOptions;
import org.apache.flink.connector.hbase.table.HBaseConnectorOptions;
import org.apache.flink.connector.hbase.util.HBaseConfigurationUtil;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.table.types.DataType;

@Internal
public class HBaseConnectorOptionsUtil {
    public static final String PROPERTIES_PREFIX = "properties.";

    public static void validatePrimaryKey(DataType dataType, int[] primaryKeyIndexes) {
        HBaseTableSchema hbaseSchema = HBaseTableSchema.fromDataType(dataType);
        if (!hbaseSchema.getRowKeyName().isPresent()) {
            throw new IllegalArgumentException("HBase table requires to define a row key field. A row key field is defined as an atomic type, column families and qualifiers are defined as ROW type.");
        }
        if (primaryKeyIndexes.length == 0) {
            return;
        }
        if (primaryKeyIndexes.length > 1) {
            throw new IllegalArgumentException("HBase table doesn't support a primary Key on multiple columns. The primary key of HBase table must be defined on row key field.");
        }
        if (!hbaseSchema.getRowKeyName().get().equals(DataType.getFieldNames((DataType)dataType).get(primaryKeyIndexes[0]))) {
            throw new IllegalArgumentException("Primary key of HBase table must be defined on the row key field. A row key field is defined as an atomic type, column families and qualifiers are defined as ROW type.");
        }
    }

    public static HBaseWriteOptions getHBaseWriteOptions(ReadableConfig tableOptions) {
        HBaseWriteOptions.Builder builder = HBaseWriteOptions.builder();
        builder.setBufferFlushIntervalMillis(((Duration)tableOptions.get(HBaseConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL)).toMillis());
        builder.setBufferFlushMaxRows(((Integer)tableOptions.get(HBaseConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS)).intValue());
        builder.setBufferFlushMaxSizeInBytes(((MemorySize)tableOptions.get(HBaseConnectorOptions.SINK_BUFFER_FLUSH_MAX_SIZE)).getBytes());
        builder.setParallelism(tableOptions.getOptional(HBaseConnectorOptions.SINK_PARALLELISM).orElse(null));
        return builder.build();
    }

    public static org.apache.hadoop.conf.Configuration getHBaseConfiguration(ReadableConfig tableOptions) {
        org.apache.hadoop.conf.Configuration hbaseClientConf = HBaseConfigurationUtil.getHBaseConfiguration();
        hbaseClientConf.set("hbase.zookeeper.quorum", (String)tableOptions.get(HBaseConnectorOptions.ZOOKEEPER_QUORUM));
        hbaseClientConf.set("zookeeper.znode.parent", (String)tableOptions.get(HBaseConnectorOptions.ZOOKEEPER_ZNODE_PARENT));
        Properties properties = HBaseConnectorOptionsUtil.getHBaseClientProperties(((Configuration)tableOptions).toMap());
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> hbaseClientConf.set(k.toString(), v.toString())));
        return hbaseClientConf;
    }

    private static Properties getHBaseClientProperties(Map<String, String> tableOptions) {
        Properties hbaseProperties = new Properties();
        if (HBaseConnectorOptionsUtil.containsHBaseClientProperties(tableOptions)) {
            tableOptions.keySet().stream().filter(key -> key.startsWith(PROPERTIES_PREFIX)).forEach(key -> {
                String value = (String)tableOptions.get(key);
                String subKey = key.substring(PROPERTIES_PREFIX.length());
                hbaseProperties.put(subKey, value);
            });
        }
        return hbaseProperties;
    }

    private static boolean containsHBaseClientProperties(Map<String, String> tableOptions) {
        return tableOptions.keySet().stream().anyMatch(k -> k.startsWith(PROPERTIES_PREFIX));
    }

    private HBaseConnectorOptionsUtil() {
    }
}

