/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.Cell;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.KeyValue;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.codec.BaseDecoder;
import org.apache.hadoop.hbase.codec.BaseEncoder;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class KeyValueCodecWithTags
implements Codec {
    @Override
    public Codec.Decoder getDecoder(InputStream is) {
        return new KeyValueDecoder(is);
    }

    @Override
    public Codec.Encoder getEncoder(OutputStream os) {
        return new KeyValueEncoder(os);
    }

    @Override
    public Codec.Decoder getDecoder(ByteBuff buf) {
        return new ByteBuffKeyValueDecoder(buf);
    }

    public static class ByteBuffKeyValueDecoder
    extends KeyValueCodec.ByteBuffKeyValueDecoder {
        public ByteBuffKeyValueDecoder(ByteBuff buf) {
            super(buf);
        }

        @Override
        protected Cell createCell(byte[] buf, int offset, int len) {
            return new KeyValue(buf, offset, len);
        }

        @Override
        protected Cell createCell(ByteBuffer bb, int pos, int len) {
            return new ByteBufferKeyValue(bb, pos, len);
        }
    }

    public static class KeyValueDecoder
    extends BaseDecoder {
        public KeyValueDecoder(InputStream in) {
            super(in);
        }

        @Override
        protected Cell parseCell() throws IOException {
            return KeyValueUtil.createKeyValueFromInputStream(this.in, true);
        }
    }

    public static class KeyValueEncoder
    extends BaseEncoder {
        public KeyValueEncoder(OutputStream out) {
            super(out);
        }

        @Override
        public void write(Cell cell) throws IOException {
            this.checkFlushed();
            ByteBufferUtils.putInt(this.out, KeyValueUtil.getSerializedSize(cell, true));
            KeyValueUtil.oswrite(cell, this.out, true);
        }
    }
}

