/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.ObjectPool;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SoftObjectPool<K, V>
extends ObjectPool<K, V> {
    public SoftObjectPool(ObjectPool.ObjectFactory<K, V> objectFactory) {
        super(objectFactory);
    }

    public SoftObjectPool(ObjectPool.ObjectFactory<K, V> objectFactory, int initialCapacity) {
        super(objectFactory, initialCapacity);
    }

    public SoftObjectPool(ObjectPool.ObjectFactory<K, V> objectFactory, int initialCapacity, int concurrencyLevel) {
        super(objectFactory, initialCapacity, concurrencyLevel);
    }

    @Override
    public Reference<V> createReference(K key, V obj) {
        return new SoftObjectReference(key, obj);
    }

    @Override
    public K getReferenceKey(Reference<V> ref) {
        return ((SoftObjectReference)ref).key;
    }

    private class SoftObjectReference
    extends SoftReference<V> {
        final K key;

        SoftObjectReference(K key, V obj) {
            super(obj, SoftObjectPool.this.staleRefQueue);
            this.key = key;
        }
    }
}

