/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util;

import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.Cell;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.CellHashKey;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RowColBloomHashKey
extends CellHashKey {
    private final int rowLength;
    private final int qualLength;

    public RowColBloomHashKey(Cell cell) {
        super(cell);
        this.rowLength = cell.getRowLength();
        this.qualLength = cell.getQualifierLength();
    }

    @Override
    public byte get(int offset) {
        if (offset < 2) {
            int rowlen = this.rowLength;
            byte b = (byte)rowlen;
            if (offset == 0) {
                b = (byte)(rowlen >>= 8);
            }
            return b;
        }
        int refLen = 2 + this.rowLength;
        if (offset < refLen) {
            return PrivateCellUtil.getRowByte((Cell)this.t, offset - 2);
        }
        if (offset == refLen) {
            return 0;
        }
        if (offset < (refLen += this.qualLength + 1)) {
            return PrivateCellUtil.getQualifierByte((Cell)this.t, offset - (2 + this.rowLength + 1));
        }
        if (offset < (refLen += 8)) {
            return LATEST_TS[offset - (2 + this.rowLength + this.qualLength + 1)];
        }
        return MAX_TYPE;
    }

    @Override
    public int length() {
        return 2 + ((Cell)this.t).getRowLength() + 1 + ((Cell)this.t).getQualifierLength() + 9;
    }
}

