/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.security;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SecurityInfo {
    private static ConcurrentMap<String, SecurityInfo> infos = new ConcurrentHashMap<String, SecurityInfo>();
    private final String serverPrincipal;
    private final AuthenticationProtos.TokenIdentifier.Kind tokenKind;

    public static void addInfo(String serviceName, SecurityInfo securityInfo) {
        infos.putIfAbsent(serviceName, securityInfo);
    }

    public static SecurityInfo getInfo(String serviceName) {
        return (SecurityInfo)infos.get(serviceName);
    }

    public SecurityInfo(String serverPrincipal, AuthenticationProtos.TokenIdentifier.Kind tokenKind) {
        this.serverPrincipal = serverPrincipal;
        this.tokenKind = tokenKind;
    }

    public String getServerPrincipal() {
        return this.serverPrincipal;
    }

    public AuthenticationProtos.TokenIdentifier.Kind getTokenKind() {
        return this.tokenKind;
    }

    static {
        infos.put(AdminProtos.AdminService.getDescriptor().getName(), new SecurityInfo("hbase.regionserver.kerberos.principal", AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN));
        infos.put(ClientProtos.ClientService.getDescriptor().getName(), new SecurityInfo("hbase.regionserver.kerberos.principal", AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN));
        infos.put(MasterProtos.MasterService.getDescriptor().getName(), new SecurityInfo("hbase.master.kerberos.principal", AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN));
        infos.put(RegionServerStatusProtos.RegionServerStatusService.getDescriptor().getName(), new SecurityInfo("hbase.master.kerberos.principal", AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN));
        infos.put(MasterProtos.HbckService.getDescriptor().getName(), new SecurityInfo("hbase.master.kerberos.principal", AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN));
    }
}

