/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.io.crypto;

import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.io.crypto.CipherProvider;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.io.crypto.aes.CommonsCryptoAES;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class CryptoCipherProvider
implements CipherProvider {
    private static CryptoCipherProvider instance;
    private Configuration conf = HBaseConfiguration.create();

    public static CryptoCipherProvider getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new CryptoCipherProvider();
        return instance;
    }

    private CryptoCipherProvider() {
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public String getName() {
        return "commons";
    }

    @Override
    public Cipher getCipher(String name) {
        if (name.equalsIgnoreCase("AES")) {
            return new CommonsCryptoAES(this);
        }
        throw new RuntimeException("Cipher '" + name + "' is not supported by provider '" + this.getName() + "'");
    }

    @Override
    public String[] getSupportedCiphers() {
        return new String[]{"AES"};
    }
}

