/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.io;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buf;

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() {
        if (this.buf.hasRemaining()) {
            return this.buf.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int avail = this.available();
        if (avail <= 0) {
            return -1;
        }
        if (len > avail) {
            len = avail;
        }
        if (len <= 0) {
            return 0;
        }
        ByteBufferUtils.copyFromBufferToArray(b, this.buf, this.buf.position(), off, len);
        this.buf.position(this.buf.position() + len);
        return len;
    }

    @Override
    public long skip(long n) {
        long k = Math.min(n, (long)this.available());
        if (k < 0L) {
            k = 0L;
        }
        this.buf.position((int)((long)this.buf.position() + k));
        return k;
    }

    @Override
    public int available() {
        return this.buf.remaining();
    }
}

