/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.Cell;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.filter.Filter;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class FirstKeyOnlyFilter
extends FilterBase {
    private boolean foundKV = false;

    @Override
    public void reset() {
        this.foundKV = false;
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        return false;
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) {
        if (this.foundKV) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        this.foundKV = true;
        return Filter.ReturnCode.INCLUDE;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.isEmpty(), "Expected 0 but got: %s", filterArguments.size());
        return new FirstKeyOnlyFilter();
    }

    protected boolean hasFoundKV() {
        return this.foundKV;
    }

    protected void setFoundKV(boolean value) {
        this.foundKV = value;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.FirstKeyOnlyFilter.Builder builder = FilterProtos.FirstKeyOnlyFilter.newBuilder();
        return builder.build().toByteArray();
    }

    public static FirstKeyOnlyFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        try {
            FilterProtos.FirstKeyOnlyFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new FirstKeyOnlyFilter();
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        return o instanceof FirstKeyOnlyFilter;
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Objects.hashCode(this.foundKV);
    }
}

