/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.backoff;

import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ServerName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class ClientBackoffPolicyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ClientBackoffPolicyFactory.class);

    private ClientBackoffPolicyFactory() {
    }

    public static ClientBackoffPolicy create(Configuration conf) {
        String className = conf.get("hbase.client.statistics.backoff-policy", NoBackoffPolicy.class.getName());
        return (ClientBackoffPolicy)ReflectionUtils.instantiateWithCustomCtor(className, new Class[]{Configuration.class}, new Object[]{conf});
    }

    public static class NoBackoffPolicy
    implements ClientBackoffPolicy {
        public NoBackoffPolicy(Configuration conf) {
        }

        @Override
        public long getBackoffTime(ServerName serverName, byte[] region, ServerStatistics stats) {
            return 0L;
        }
    }
}

