/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class CoprocessorDescriptorBuilder {
    private final String className;
    private String jarPath;
    private int priority = 0x3FFFFFFF;
    private Map<String, String> properties = new TreeMap<String, String>();

    public static CoprocessorDescriptor of(String className) {
        return new CoprocessorDescriptorBuilder(className).build();
    }

    public static CoprocessorDescriptorBuilder newBuilder(String className) {
        return new CoprocessorDescriptorBuilder(className);
    }

    public CoprocessorDescriptorBuilder setJarPath(String jarPath) {
        this.jarPath = jarPath;
        return this;
    }

    public CoprocessorDescriptorBuilder setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public CoprocessorDescriptorBuilder setProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public CoprocessorDescriptorBuilder setProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public CoprocessorDescriptor build() {
        return new CoprocessorDescriptorImpl(this.className, this.jarPath, this.priority, this.properties);
    }

    private CoprocessorDescriptorBuilder(String className) {
        this.className = Objects.requireNonNull(className);
    }

    private static final class CoprocessorDescriptorImpl
    implements CoprocessorDescriptor {
        private final String className;
        private final String jarPath;
        private final int priority;
        private final Map<String, String> properties;

        private CoprocessorDescriptorImpl(String className, String jarPath, int priority, Map<String, String> properties) {
            this.className = className;
            this.jarPath = jarPath;
            this.priority = priority;
            this.properties = properties;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public Optional<String> getJarPath() {
            return Optional.ofNullable(this.jarPath);
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public Map<String, String> getProperties() {
            return Collections.unmodifiableMap(this.properties);
        }

        public String toString() {
            return "class:" + this.className + ", jarPath:" + this.jarPath + ", priority:" + this.priority + ", properties:" + this.properties;
        }
    }
}

