/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.commons.crypto;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import org.apache.flink.hbase.shaded.org.apache.commons.crypto.OsInfo;
import org.apache.flink.hbase.shaded.org.apache.commons.crypto.utils.IoUtils;
import org.apache.flink.hbase.shaded.org.apache.commons.crypto.utils.Utils;

final class NativeCodeLoader {
    private static final boolean nativeCodeLoaded;
    private static final Throwable loadingError;

    private NativeCodeLoader() {
    }

    static Throwable loadLibrary() {
        try {
            File nativeLibFile = NativeCodeLoader.findNativeLibrary();
            if (nativeLibFile != null) {
                System.load(nativeLibFile.getAbsolutePath());
            } else {
                System.loadLibrary("commons-crypto");
            }
            return null;
        }
        catch (Exception t) {
            return t;
        }
        catch (UnsatisfiedLinkError t) {
            return t;
        }
    }

    private static File findNativeLibrary() {
        File nativeLib;
        Properties props = Utils.getDefaultProperties();
        String nativeLibraryPath = props.getProperty("commons.crypto.lib.path");
        String nativeLibraryName = props.getProperty("commons.crypto.lib.name");
        if (nativeLibraryName == null) {
            nativeLibraryName = System.mapLibraryName("commons-crypto");
        }
        if (nativeLibraryPath != null && (nativeLib = new File(nativeLibraryPath, nativeLibraryName)).exists()) {
            return nativeLib;
        }
        nativeLibraryPath = "/org/apache/flink/hbase/shaded/org/apache/commons/crypto/native/" + OsInfo.getNativeLibFolderPathForCurrentOS();
        boolean hasNativeLib = NativeCodeLoader.hasResource(nativeLibraryPath + "/" + nativeLibraryName);
        if (!hasNativeLib) {
            String altName = "libcommons-crypto.jnilib";
            if (OsInfo.getOSName().equals("Mac") && NativeCodeLoader.hasResource(nativeLibraryPath + "/" + altName)) {
                nativeLibraryName = altName;
                hasNativeLib = true;
            }
        }
        if (!hasNativeLib) {
            String errorMessage = String.format("no native library is found for os.name=%s and os.arch=%s", OsInfo.getOSName(), OsInfo.getArchName());
            throw new RuntimeException(errorMessage);
        }
        String tempFolder = new File(props.getProperty("commons.crypto.lib.tempdir", System.getProperty("java.io.tmpdir"))).getAbsolutePath();
        return NativeCodeLoader.extractLibraryFile(nativeLibraryPath, nativeLibraryName, tempFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractLibraryFile(String libFolderForCurrentOS, String libraryFileName, String targetFolder) {
        File file;
        String nativeLibraryFilePath = libFolderForCurrentOS + "/" + libraryFileName;
        String uuid = UUID.randomUUID().toString();
        String extractedLibFileName = String.format("commons-crypto-%s-%s", uuid, libraryFileName);
        File extractedLibFile = new File(targetFolder, extractedLibFileName);
        InputStream reader = null;
        try {
            reader = NativeCodeLoader.class.getResourceAsStream(nativeLibraryFilePath);
            FileOutputStream writer = new FileOutputStream(extractedLibFile);
            try {
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, bytesRead);
                }
                extractedLibFile.deleteOnExit();
            }
            catch (Throwable throwable) {
                extractedLibFile.deleteOnExit();
                writer.close();
                IoUtils.cleanup(reader);
                reader = null;
                throw throwable;
            }
            writer.close();
            IoUtils.cleanup(reader);
            reader = null;
            if (!(extractedLibFile.setReadable(true) && extractedLibFile.setExecutable(true) && extractedLibFile.setWritable(true, true))) {
                throw new RuntimeException("Invalid path for library path");
            }
            InputStream nativeIn = null;
            InputStream extractedLibIn = null;
            try {
                nativeIn = NativeCodeLoader.class.getResourceAsStream(nativeLibraryFilePath);
                extractedLibIn = new FileInputStream(extractedLibFile);
                if (!NativeCodeLoader.contentsEquals(nativeIn, extractedLibIn)) {
                    throw new RuntimeException(String.format("Failed to write a native library file at %s", extractedLibFile));
                }
            }
            finally {
                if (nativeIn != null) {
                    nativeIn.close();
                }
                if (extractedLibIn != null) {
                    extractedLibIn.close();
                }
            }
            file = extractedLibFile;
        }
        catch (IOException e) {
            File file2;
            try {
                file2 = null;
            }
            catch (Throwable throwable) {
                IoUtils.cleanup(reader);
                throw throwable;
            }
            IoUtils.cleanup(reader);
            return file2;
        }
        IoUtils.cleanup(reader);
        return file;
    }

    private static boolean contentsEquals(InputStream in1, InputStream in2) throws IOException {
        int ch2;
        if (!(in1 instanceof BufferedInputStream)) {
            in1 = new BufferedInputStream(in1);
        }
        if (!(in2 instanceof BufferedInputStream)) {
            in2 = new BufferedInputStream(in2);
        }
        int ch = in1.read();
        while (ch != -1) {
            ch2 = in2.read();
            if (ch != ch2) {
                return false;
            }
            ch = in1.read();
        }
        ch2 = in2.read();
        return ch2 == -1;
    }

    private static boolean hasResource(String path) {
        return NativeCodeLoader.class.getResource(path) != null;
    }

    static boolean isNativeCodeLoaded() {
        return nativeCodeLoaded;
    }

    static Throwable getLoadingError() {
        return loadingError;
    }

    static {
        loadingError = NativeCodeLoader.loadLibrary();
        nativeCodeLoaded = loadingError == null;
    }
}

