/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase2.source;

import java.io.IOException;
import org.apache.flink.connector.hbase.util.HBaseSerde;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.connector.hbase2.source.AbstractTableInputFormat;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Result;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Scan;
import org.apache.flink.table.data.RowData;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseRowDataInputFormat
extends AbstractTableInputFormat<RowData> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HBaseRowDataInputFormat.class);
    private final String tableName;
    private final HBaseTableSchema schema;
    private final String nullStringLiteral;
    private transient HBaseSerde serde;

    public HBaseRowDataInputFormat(Configuration conf, String tableName, HBaseTableSchema schema, String nullStringLiteral) {
        super(conf);
        this.tableName = tableName;
        this.schema = schema;
        this.nullStringLiteral = nullStringLiteral;
    }

    @Override
    protected void initTable() throws IOException {
        this.serde = new HBaseSerde(this.schema, this.nullStringLiteral);
        if (this.table == null) {
            this.connectToTable();
        }
        if (this.table != null && this.scan == null) {
            this.scan = this.getScanner();
        }
    }

    @Override
    protected Scan getScanner() {
        return this.serde.createScan();
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    protected RowData mapResultToOutType(Result res) {
        return this.serde.convertToReusedRow(res);
    }

    private void connectToTable() throws IOException {
        try {
            if (this.connection == null) {
                this.connection = ConnectionFactory.createConnection(this.getHadoopConfiguration());
            }
            TableName name = TableName.valueOf(this.getTableName());
            this.table = this.connection.getTable(name);
            this.regionLocator = this.connection.getRegionLocator(name);
        }
        catch (TableNotFoundException tnfe) {
            LOG.error("The table " + this.tableName + " not found ", (Throwable)tnfe);
            throw new RuntimeException("HBase table '" + this.tableName + "' not found.", tnfe);
        }
    }
}

