/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase2.source;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.connector.hbase.source.AbstractHBaseDynamicTableSource;
import org.apache.flink.connector.hbase.source.HBaseRowDataLookupFunction;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.connector.hbase2.source.HBaseRowDataAsyncLookupFunction;
import org.apache.flink.connector.hbase2.source.HBaseRowDataInputFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.lookup.AsyncLookupFunctionProvider;
import org.apache.flink.table.connector.source.lookup.LookupFunctionProvider;
import org.apache.flink.table.connector.source.lookup.PartialCachingAsyncLookupProvider;
import org.apache.flink.table.connector.source.lookup.PartialCachingLookupProvider;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.AsyncLookupFunction;
import org.apache.flink.table.functions.LookupFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;

@Internal
public class HBaseDynamicTableSource
extends AbstractHBaseDynamicTableSource {
    private final boolean lookupAsync;

    public HBaseDynamicTableSource(Configuration conf, String tableName, HBaseTableSchema hbaseSchema, String nullStringLiteral, int maxRetryTimes, boolean lookupAsync, @Nullable LookupCache cache) {
        super(conf, tableName, hbaseSchema, nullStringLiteral, maxRetryTimes, cache);
        this.lookupAsync = lookupAsync;
    }

    @Override
    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext context) {
        Preconditions.checkArgument((context.getKeys().length == 1 && context.getKeys()[0].length == 1 ? 1 : 0) != 0, (Object)"Currently, HBase table can only be lookup by single rowkey.");
        Preconditions.checkArgument((boolean)this.hbaseSchema.getRowKeyName().isPresent(), (Object)"HBase schema must have a row key when used in lookup mode.");
        Preconditions.checkArgument((boolean)((String)DataType.getFieldNames((DataType)this.hbaseSchema.convertToDataType()).get(context.getKeys()[0][0])).equals(this.hbaseSchema.getRowKeyName().get()), (Object)"Currently, HBase table only supports lookup by rowkey field.");
        if (this.lookupAsync) {
            HBaseRowDataAsyncLookupFunction asyncLookupFunction = new HBaseRowDataAsyncLookupFunction(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral, this.maxRetryTimes);
            if (this.cache != null) {
                return PartialCachingAsyncLookupProvider.of((AsyncLookupFunction)asyncLookupFunction, (LookupCache)this.cache);
            }
            return AsyncLookupFunctionProvider.of((AsyncLookupFunction)asyncLookupFunction);
        }
        HBaseRowDataLookupFunction lookupFunction = new HBaseRowDataLookupFunction(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral, this.maxRetryTimes);
        if (this.cache != null) {
            return PartialCachingLookupProvider.of((LookupFunction)lookupFunction, (LookupCache)this.cache);
        }
        return LookupFunctionProvider.of((LookupFunction)lookupFunction);
    }

    public DynamicTableSource copy() {
        return new HBaseDynamicTableSource(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral, this.maxRetryTimes, this.lookupAsync, this.cache);
    }

    @Override
    protected InputFormat<RowData, ?> getInputFormat() {
        return new HBaseRowDataInputFormat(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral);
    }

    public boolean equals(Object o) {
        if (!(o instanceof HBaseDynamicTableSource)) {
            return false;
        }
        HBaseDynamicTableSource that = (HBaseDynamicTableSource)o;
        return Objects.equals(this.conf, that.conf) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.hbaseSchema, that.hbaseSchema) && Objects.equals(this.nullStringLiteral, that.nullStringLiteral) && Objects.equals(this.maxRetryTimes, that.maxRetryTimes) && Objects.equals(this.cache, that.cache) && Objects.equals(this.lookupAsync, that.lookupAsync);
    }

    public int hashCode() {
        return Objects.hash(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral, this.maxRetryTimes, this.cache, this.lookupAsync);
    }
}

