/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.htrace.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.hbase.shaded.org.apache.htrace.fasterxml.jackson.core.JsonParser;
import org.apache.flink.hbase.shaded.org.apache.htrace.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.hbase.shaded.org.apache.htrace.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.hbase.shaded.org.apache.htrace.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.hbase.shaded.org.apache.htrace.fasterxml.jackson.databind.deser.SettableBeanProperty;
import org.apache.flink.hbase.shaded.org.apache.htrace.fasterxml.jackson.databind.util.NameTransformer;
import org.apache.flink.hbase.shaded.org.apache.htrace.fasterxml.jackson.databind.util.TokenBuffer;

public class UnwrappedPropertyHandler {
    protected final List<SettableBeanProperty> _properties;

    public UnwrappedPropertyHandler() {
        this._properties = new ArrayList<SettableBeanProperty>();
    }

    protected UnwrappedPropertyHandler(List<SettableBeanProperty> props) {
        this._properties = props;
    }

    public void addProperty(SettableBeanProperty property) {
        this._properties.add(property);
    }

    public UnwrappedPropertyHandler renameAll(NameTransformer transformer) {
        ArrayList<SettableBeanProperty> newProps = new ArrayList<SettableBeanProperty>(this._properties.size());
        for (SettableBeanProperty prop : this._properties) {
            JsonDeserializer<Object> newDeser;
            String newName = transformer.transform(prop.getName());
            JsonDeserializer<Object> deser = (prop = prop.withSimpleName(newName)).getValueDeserializer();
            if (deser != null && (newDeser = deser.unwrappingDeserializer(transformer)) != deser) {
                prop = prop.withValueDeserializer(newDeser);
            }
            newProps.add(prop);
        }
        return new UnwrappedPropertyHandler(newProps);
    }

    public Object processUnwrapped(JsonParser originalParser, DeserializationContext ctxt, Object bean, TokenBuffer buffered) throws IOException, JsonProcessingException {
        int len = this._properties.size();
        for (int i = 0; i < len; ++i) {
            SettableBeanProperty prop = this._properties.get(i);
            JsonParser jp = buffered.asParser();
            jp.nextToken();
            prop.deserializeAndSet(jp, ctxt, bean);
        }
        return bean;
    }
}

