/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util;

import java.util.concurrent.TimeUnit;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.Log;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class RetryCounter {
    private static final Log LOG = LogFactory.getLog(RetryCounter.class);
    private RetryConfig retryConfig;
    private int attempts = 0;

    public RetryCounter(int maxAttempts, long sleepInterval, TimeUnit timeUnit) {
        this(new RetryConfig(maxAttempts, sleepInterval, -1L, timeUnit, new ExponentialBackoffPolicy()));
    }

    public RetryCounter(RetryConfig retryConfig) {
        this.retryConfig = retryConfig;
    }

    public int getMaxAttempts() {
        return this.retryConfig.getMaxAttempts();
    }

    public void sleepUntilNextRetry() throws InterruptedException {
        int attempts = this.getAttemptTimes();
        long sleepTime = this.retryConfig.backoffPolicy.getBackoffTime(this.retryConfig, attempts);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sleeping " + sleepTime + "ms before retry #" + attempts + "...");
        }
        this.retryConfig.getTimeUnit().sleep(sleepTime);
        this.useRetry();
    }

    public boolean shouldRetry() {
        return this.attempts < this.retryConfig.getMaxAttempts();
    }

    public void useRetry() {
        ++this.attempts;
    }

    public boolean isRetry() {
        return this.attempts > 0;
    }

    public int getAttemptTimes() {
        return this.attempts;
    }

    public static class ExponentialBackoffPolicyWithLimit
    extends ExponentialBackoffPolicy {
        @Override
        public long getBackoffTime(RetryConfig config, int attempts) {
            long backoffTime = super.getBackoffTime(config, attempts);
            return config.getMaxSleepTime() > 0L ? Math.min(backoffTime, config.getMaxSleepTime()) : backoffTime;
        }
    }

    public static class ExponentialBackoffPolicy
    extends BackoffPolicy {
        @Override
        public long getBackoffTime(RetryConfig config, int attempts) {
            long backoffTime = (long)((double)config.getSleepInterval() * Math.pow(2.0, attempts));
            return backoffTime;
        }
    }

    public static class BackoffPolicy {
        public long getBackoffTime(RetryConfig config, int attempts) {
            return config.getSleepInterval();
        }
    }

    public static class RetryConfig {
        private int maxAttempts;
        private long sleepInterval;
        private long maxSleepTime;
        private TimeUnit timeUnit;
        private BackoffPolicy backoffPolicy;
        private static final BackoffPolicy DEFAULT_BACKOFF_POLICY = new ExponentialBackoffPolicy();

        public RetryConfig() {
            this.maxAttempts = 1;
            this.sleepInterval = 1000L;
            this.maxSleepTime = -1L;
            this.timeUnit = TimeUnit.MILLISECONDS;
            this.backoffPolicy = DEFAULT_BACKOFF_POLICY;
        }

        public RetryConfig(int maxAttempts, long sleepInterval, long maxSleepTime, TimeUnit timeUnit, BackoffPolicy backoffPolicy) {
            this.maxAttempts = maxAttempts;
            this.sleepInterval = sleepInterval;
            this.maxSleepTime = maxSleepTime;
            this.timeUnit = timeUnit;
            this.backoffPolicy = backoffPolicy;
        }

        public RetryConfig setBackoffPolicy(BackoffPolicy backoffPolicy) {
            this.backoffPolicy = backoffPolicy;
            return this;
        }

        public RetryConfig setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public RetryConfig setMaxSleepTime(long maxSleepTime) {
            this.maxSleepTime = maxSleepTime;
            return this;
        }

        public RetryConfig setSleepInterval(long sleepInterval) {
            this.sleepInterval = sleepInterval;
            return this;
        }

        public RetryConfig setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        public long getMaxSleepTime() {
            return this.maxSleepTime;
        }

        public long getSleepInterval() {
            return this.sleepInterval;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public BackoffPolicy getBackoffPolicy() {
            return this.backoffPolicy;
        }
    }
}

