/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.security.token;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.Log;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.HConstants;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Connection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Table;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.security.User;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.security.UserProvider;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.security.token.AuthenticationTokenSelector;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TokenUtil {
    private static final Log LOG = LogFactory.getLog(TokenUtil.class);

    @Deprecated
    public static Token<AuthenticationTokenIdentifier> obtainToken(Configuration conf) throws IOException {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            Token<AuthenticationTokenIdentifier> token = TokenUtil.obtainToken(connection);
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Token<AuthenticationTokenIdentifier> obtainToken(Connection conn) throws IOException {
        try (Table meta = null;){
            meta = conn.getTable(TableName.META_TABLE_NAME);
            CoprocessorRpcChannel rpcChannel = meta.coprocessorService(HConstants.EMPTY_START_ROW);
            AuthenticationProtos.AuthenticationService.BlockingInterface service = AuthenticationProtos.AuthenticationService.newBlockingStub(rpcChannel);
            AuthenticationProtos.GetAuthenticationTokenResponse response = service.getAuthenticationToken(null, AuthenticationProtos.GetAuthenticationTokenRequest.getDefaultInstance());
            Token<AuthenticationTokenIdentifier> token = ProtobufUtil.toToken(response.getToken());
            return token;
        }
        return null;
    }

    public static Token<AuthenticationTokenIdentifier> obtainToken(final Connection conn, User user) throws IOException, InterruptedException {
        return user.runAs(new PrivilegedExceptionAction<Token<AuthenticationTokenIdentifier>>(){

            @Override
            public Token<AuthenticationTokenIdentifier> run() throws Exception {
                return TokenUtil.obtainToken(conn);
            }
        });
    }

    private static Text getClusterId(Token<AuthenticationTokenIdentifier> token) throws IOException {
        return token.getService() != null ? token.getService() : new Text("default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void obtainAndCacheToken(Configuration conf, UserGroupInformation user) throws IOException, InterruptedException {
        try (Connection conn = ConnectionFactory.createConnection(conf);){
            UserProvider userProvider = UserProvider.instantiate(conf);
            TokenUtil.obtainAndCacheToken(conn, userProvider.create(user));
        }
    }

    public static void obtainAndCacheToken(Connection conn, User user) throws IOException, InterruptedException {
        try {
            Token<AuthenticationTokenIdentifier> token = TokenUtil.obtainToken(conn, user);
            if (token == null) {
                throw new IOException("No token returned for user " + user.getName());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Obtained token " + token.getKind().toString() + " for user " + user.getName());
            }
            user.addToken(token);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, "Unexpected exception obtaining token for user " + user.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void obtainTokenForJob(Configuration conf, UserGroupInformation user, Job job) throws IOException, InterruptedException {
        try (Connection conn = ConnectionFactory.createConnection(conf);){
            UserProvider userProvider = UserProvider.instantiate(conf);
            TokenUtil.obtainTokenForJob(conn, userProvider.create(user), job);
        }
    }

    public static void obtainTokenForJob(Connection conn, User user, Job job) throws IOException, InterruptedException {
        try {
            Token<AuthenticationTokenIdentifier> token = TokenUtil.obtainToken(conn, user);
            if (token == null) {
                throw new IOException("No token returned for user " + user.getName());
            }
            Text clusterId = TokenUtil.getClusterId(token);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Obtained token " + token.getKind().toString() + " for user " + user.getName() + " on cluster " + clusterId.toString());
            }
            job.getCredentials().addToken(clusterId, token);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, "Unexpected exception obtaining token for user " + user.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void obtainTokenForJob(JobConf job, UserGroupInformation user) throws IOException, InterruptedException {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)job);){
            UserProvider userProvider = UserProvider.instantiate((Configuration)job);
            TokenUtil.obtainTokenForJob(conn, job, userProvider.create(user));
        }
    }

    public static void obtainTokenForJob(Connection conn, JobConf job, User user) throws IOException, InterruptedException {
        try {
            Token<AuthenticationTokenIdentifier> token = TokenUtil.obtainToken(conn, user);
            if (token == null) {
                throw new IOException("No token returned for user " + user.getName());
            }
            Text clusterId = TokenUtil.getClusterId(token);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Obtained token " + token.getKind().toString() + " for user " + user.getName() + " on cluster " + clusterId.toString());
            }
            job.getCredentials().addToken(clusterId, token);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, "Unexpected exception obtaining token for user " + user.getName());
        }
    }

    public static void addTokenForJob(Connection conn, JobConf job, User user) throws IOException, InterruptedException {
        Token<AuthenticationTokenIdentifier> token = TokenUtil.getAuthToken(conn.getConfiguration(), user);
        if (token == null) {
            token = TokenUtil.obtainToken(conn, user);
        }
        job.getCredentials().addToken(token.getService(), token);
    }

    public static void addTokenForJob(Connection conn, User user, Job job) throws IOException, InterruptedException {
        Token<AuthenticationTokenIdentifier> token = TokenUtil.getAuthToken(conn.getConfiguration(), user);
        if (token == null) {
            token = TokenUtil.obtainToken(conn, user);
        }
        job.getCredentials().addToken(token.getService(), token);
    }

    public static boolean addTokenIfMissing(Connection conn, User user) throws IOException, InterruptedException {
        Token<AuthenticationTokenIdentifier> token = TokenUtil.getAuthToken(conn.getConfiguration(), user);
        if (token == null) {
            token = TokenUtil.obtainToken(conn, user);
            user.getUGI().addToken(token.getService(), token);
            return true;
        }
        return false;
    }

    private static Token<AuthenticationTokenIdentifier> getAuthToken(Configuration conf, User user) throws IOException, InterruptedException {
        try (ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "TokenUtil-getAuthToken", null);){
            String clusterId = ZKClusterId.readClusterIdZNode(zkw);
            if (clusterId == null) {
                throw new IOException("Failed to get cluster ID");
            }
            Token<AuthenticationTokenIdentifier> token = new AuthenticationTokenSelector().selectToken(new Text(clusterId), user.getTokens());
            return token;
        }
    }
}

