/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ServerName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.StatisticTrackable;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
public class ServerStatisticTracker
implements StatisticTrackable {
    private final ConcurrentHashMap<ServerName, ServerStatistics> stats = new ConcurrentHashMap();

    @Override
    public void updateRegionStats(ServerName server, byte[] region, ClientProtos.RegionLoadStats currentStats) {
        ServerStatistics old;
        ServerStatistics stat = this.stats.get(server);
        if (stat == null && (stat = this.stats.get(server)) == null && (old = this.stats.putIfAbsent(server, stat = new ServerStatistics())) != null) {
            stat = old;
        }
        stat.update(region, currentStats);
    }

    public ServerStatistics getStats(ServerName server) {
        return this.stats.get(server);
    }

    public static ServerStatisticTracker create(Configuration conf) {
        if (!conf.getBoolean("hbase.client.backpressure.enabled", false)) {
            return null;
        }
        return new ServerStatisticTracker();
    }

    @VisibleForTesting
    ServerStatistics getServerStatsForTesting(ServerName server) {
        return this.stats.get(server);
    }
}

