/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Bytes;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
public class HBaseTypeUtils {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int MIN_TIMESTAMP_PRECISION = 0;
    private static final int MAX_TIMESTAMP_PRECISION = 3;
    private static final int MIN_TIME_PRECISION = 0;
    private static final int MAX_TIME_PRECISION = 3;

    public static Object deserializeToObject(byte[] value, int typeIdx, Charset stringCharset) {
        switch (typeIdx) {
            case 0: {
                return value;
            }
            case 1: {
                return Arrays.equals(EMPTY_BYTES, value) ? null : new String(value, stringCharset);
            }
            case 2: {
                return value[0];
            }
            case 3: {
                return Bytes.toShort(value);
            }
            case 4: {
                return Bytes.toInt(value);
            }
            case 5: {
                return Bytes.toLong(value);
            }
            case 6: {
                return Float.valueOf(Bytes.toFloat(value));
            }
            case 7: {
                return Bytes.toDouble(value);
            }
            case 8: {
                return Bytes.toBoolean(value);
            }
            case 9: {
                return new Timestamp(Bytes.toLong(value));
            }
            case 10: {
                return new Date(Bytes.toLong(value));
            }
            case 11: {
                return new Time(Bytes.toLong(value));
            }
            case 12: {
                return Bytes.toBigDecimal(value);
            }
            case 13: {
                return new BigInteger(value);
            }
        }
        throw new IllegalArgumentException("unsupported type index:" + typeIdx);
    }

    public static byte[] serializeFromObject(Object value, int typeIdx, Charset stringCharset) {
        switch (typeIdx) {
            case 0: {
                return (byte[])value;
            }
            case 1: {
                return value == null ? EMPTY_BYTES : ((String)value).getBytes(stringCharset);
            }
            case 2: {
                byte[] byArray;
                if (value == null) {
                    byArray = EMPTY_BYTES;
                } else {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = (Byte)value;
                }
                return byArray;
            }
            case 3: {
                return Bytes.toBytes((Short)value);
            }
            case 4: {
                return Bytes.toBytes((Integer)value);
            }
            case 5: {
                return Bytes.toBytes((Long)value);
            }
            case 6: {
                return Bytes.toBytes(((Float)value).floatValue());
            }
            case 7: {
                return Bytes.toBytes((Double)value);
            }
            case 8: {
                return Bytes.toBytes((Boolean)value);
            }
            case 9: {
                return Bytes.toBytes(((Timestamp)value).getTime());
            }
            case 10: {
                return Bytes.toBytes(((Date)value).getTime());
            }
            case 11: {
                return Bytes.toBytes(((Time)value).getTime());
            }
            case 12: {
                return Bytes.toBytes((BigDecimal)value);
            }
            case 13: {
                return ((BigInteger)value).toByteArray();
            }
        }
        throw new IllegalArgumentException("unsupported type index:" + typeIdx);
    }

    public static int getTypeIndex(TypeInformation typeInfo) {
        return HBaseTypeUtils.getTypeIndex(typeInfo.getTypeClass());
    }

    public static boolean isSupportedType(Class<?> clazz) {
        return HBaseTypeUtils.getTypeIndex(clazz) != -1;
    }

    private static int getTypeIndex(Class<?> clazz) {
        if (byte[].class.equals(clazz)) {
            return 0;
        }
        if (String.class.equals(clazz)) {
            return 1;
        }
        if (Byte.class.equals(clazz)) {
            return 2;
        }
        if (Short.class.equals(clazz)) {
            return 3;
        }
        if (Integer.class.equals(clazz)) {
            return 4;
        }
        if (Long.class.equals(clazz)) {
            return 5;
        }
        if (Float.class.equals(clazz)) {
            return 6;
        }
        if (Double.class.equals(clazz)) {
            return 7;
        }
        if (Boolean.class.equals(clazz)) {
            return 8;
        }
        if (Timestamp.class.equals(clazz)) {
            return 9;
        }
        if (Date.class.equals(clazz)) {
            return 10;
        }
        if (Time.class.equals(clazz)) {
            return 11;
        }
        if (BigDecimal.class.equals(clazz)) {
            return 12;
        }
        if (BigInteger.class.equals(clazz)) {
            return 13;
        }
        return -1;
    }

    public static boolean isSupportedType(LogicalType type) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BOOLEAN: 
            case BINARY: 
            case VARBINARY: 
            case DECIMAL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case DATE: 
            case INTERVAL_YEAR_MONTH: 
            case BIGINT: 
            case INTERVAL_DAY_TIME: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                int timePrecision = LogicalTypeChecks.getPrecision((LogicalType)type);
                if (timePrecision < 0 || timePrecision > 3) {
                    throw new UnsupportedOperationException(String.format("The precision %s of TIME type is out of the range [%s, %s] supported by HBase connector", timePrecision, 0, 3));
                }
                return true;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int timestampPrecision = LogicalTypeChecks.getPrecision((LogicalType)type);
                if (timestampPrecision < 0 || timestampPrecision > 3) {
                    throw new UnsupportedOperationException(String.format("The precision %s of TIMESTAMP type is out of the range [%s, %s] supported by HBase connector", timestampPrecision, 0, 3));
                }
                return true;
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case ARRAY: 
            case MULTISET: 
            case MAP: 
            case ROW: 
            case STRUCTURED_TYPE: 
            case DISTINCT_TYPE: 
            case RAW: 
            case NULL: 
            case SYMBOL: 
            case UNRESOLVED: {
                return false;
            }
        }
        throw new IllegalArgumentException();
    }
}

