/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.zip.Checksum;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ChecksumFactory {
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];

    public static Checksum newInstance(String className) throws IOException {
        try {
            Class<?> clazz = ChecksumFactory.getClassByName(className);
            return (Checksum)ChecksumFactory.newInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static Constructor<?> newConstructor(String className) throws IOException {
        try {
            Class<?> clazz = ChecksumFactory.getClassByName(className);
            Constructor<?> ctor = clazz.getDeclaredConstructor(EMPTY_ARRAY);
            ctor.setAccessible(true);
            return ctor;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
    }

    private static <T> T newInstance(Class<T> theClass) {
        T result;
        try {
            Constructor<T> ctor = theClass.getDeclaredConstructor(EMPTY_ARRAY);
            ctor.setAccessible(true);
            result = ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private static Class<?> getClassByName(String name) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Class.forName(name, true, classLoader);
    }
}

