/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ArrayUtils {
    public static int length(byte[] a) {
        if (a == null) {
            return 0;
        }
        return a.length;
    }

    public static int length(long[] a) {
        if (a == null) {
            return 0;
        }
        return a.length;
    }

    public static int length(Object[] a) {
        if (a == null) {
            return 0;
        }
        return a.length;
    }

    public static boolean isEmpty(byte[] a) {
        if (a == null) {
            return true;
        }
        return a.length == 0;
    }

    public static boolean isEmpty(long[] a) {
        if (a == null) {
            return true;
        }
        return a.length == 0;
    }

    public static boolean isEmpty(Object[] a) {
        if (a == null) {
            return true;
        }
        return a.length == 0;
    }

    public static long getFirst(long[] a) {
        return a[0];
    }

    public static long getLast(long[] a) {
        return a[a.length - 1];
    }

    public static int getTotalLengthOfArrays(Iterable<byte[]> arrays) {
        if (arrays == null) {
            return 0;
        }
        int length = 0;
        for (byte[] bytes : arrays) {
            length += ArrayUtils.length(bytes);
        }
        return length;
    }

    public static ArrayList<Long> toList(long[] array) {
        int length = ArrayUtils.length(array);
        ArrayList<Long> list = new ArrayList<Long>(length);
        for (int i = 0; i < length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static byte[] growIfNecessary(byte[] array, int minLength, int numAdditionalBytes) {
        if (array.length >= minLength) {
            return array;
        }
        return Arrays.copyOf(array, minLength + numAdditionalBytes);
    }

    public static int[] growIfNecessary(int[] array, int minLength, int numAdditionalInts) {
        if (array.length >= minLength) {
            return array;
        }
        return Arrays.copyOf(array, minLength + numAdditionalInts);
    }

    public static long[] growIfNecessary(long[] array, int minLength, int numAdditionalLongs) {
        if (array.length >= minLength) {
            return array;
        }
        return Arrays.copyOf(array, minLength + numAdditionalLongs);
    }
}

